/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.controller.channel;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.AudioSegment;
import io.github.dsheirer.channel.metadata.ChannelAndMetadata;
import io.github.dsheirer.channel.metadata.ChannelMetadata;
import io.github.dsheirer.channel.metadata.ChannelMetadataModel;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelConfigurationChangeNotification;
import io.github.dsheirer.controller.channel.ChannelConversionRequest;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.controller.channel.ChannelException;
import io.github.dsheirer.controller.channel.event.ChannelStartProcessingRequest;
import io.github.dsheirer.controller.channel.event.ChannelStopProcessingRequest;
import io.github.dsheirer.controller.channel.event.PreloadDataContent;
import io.github.dsheirer.controller.channel.map.ChannelMapModel;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.identifier.decoder.DecoderLogicalChannelNameIdentifier;
import io.github.dsheirer.module.Module;
import io.github.dsheirer.module.ProcessingChain;
import io.github.dsheirer.module.decode.DecoderFactory;
import io.github.dsheirer.module.decode.event.IDecodeEvent;
import io.github.dsheirer.module.log.EventLogManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.RecorderFactory;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.Source;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.config.SourceConfigTuner;
import io.github.dsheirer.source.config.SourceConfigTunerMultipleFrequency;
import io.github.dsheirer.source.tuner.channel.TunerChannelSource;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.util.ThreadPool;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelProcessingManager
implements Listener<ChannelEvent> {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelProcessingManager.class);
    private static final String TUNER_UNAVAILABLE_DESCRIPTION = "TUNER UNAVAILABLE";
    private Map<Channel, ProcessingChain> mProcessingChains = new ConcurrentHashMap<Channel, ProcessingChain>();
    private Lock mLock = new ReentrantLock();
    private ChannelSourceEventErrorListener mSourceErrorListener = new ChannelSourceEventErrorListener();
    private List<Listener<AudioSegment>> mAudioSegmentListeners = new CopyOnWriteArrayList<Listener<AudioSegment>>();
    private List<Listener<IDecodeEvent>> mDecodeEventListeners = new CopyOnWriteArrayList<Listener<IDecodeEvent>>();
    private Broadcaster<ChannelEvent> mChannelEventBroadcaster = new Broadcaster();
    private ChannelMapModel mChannelMapModel;
    private ChannelMetadataModel mChannelMetadataModel;
    private EventLogManager mEventLogManager;
    private TunerManager mTunerManager;
    private AliasModel mAliasModel;
    private UserPreferences mUserPreferences;
    private List<Long> mLoggedFrequencies = new ArrayList<Long>();
    private List<ScheduledFuture<?>> mDelayedChannelStartTasks = new ArrayList();

    public ChannelProcessingManager(ChannelMapModel channelMapModel, EventLogManager eventLogManager, TunerManager tunerManager, AliasModel aliasModel, UserPreferences userPreferences) {
        this.mChannelMapModel = channelMapModel;
        this.mEventLogManager = eventLogManager;
        this.mTunerManager = tunerManager;
        this.mAliasModel = aliasModel;
        this.mUserPreferences = userPreferences;
        this.mChannelMetadataModel = new ChannelMetadataModel();
    }

    public ChannelMetadataModel getChannelMetadataModel() {
        return this.mChannelMetadataModel;
    }

    private boolean isProcessing(Channel channel) {
        boolean isProcessing = false;
        this.mLock.lock();
        try {
            isProcessing = this.mProcessingChains.containsKey(channel) && this.mProcessingChains.get(channel).isProcessing();
        }
        finally {
            this.mLock.unlock();
        }
        return isProcessing;
    }

    public boolean isProcessing() {
        return !this.mProcessingChains.isEmpty();
    }

    public ProcessingChain getProcessingChain(Channel channel) {
        return this.mProcessingChains.get(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(ProcessingChain processingChain) {
        Channel channel = null;
        if (processingChain != null) {
            this.mLock.lock();
            try {
                for (Map.Entry<Channel, ProcessingChain> entry : this.mProcessingChains.entrySet()) {
                    if (entry.getValue() != processingChain) continue;
                    channel = entry.getKey();
                    break;
                }
            }
            finally {
                this.mLock.unlock();
            }
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getChannel(TunerChannelSource tunerChannelSource) {
        Channel channel = null;
        this.mLock.lock();
        try {
            for (Map.Entry<Channel, ProcessingChain> entry : this.mProcessingChains.entrySet()) {
                if (!entry.getValue().hasSource(tunerChannelSource)) continue;
                channel = entry.getKey();
                break;
            }
        }
        finally {
            this.mLock.unlock();
        }
        return channel;
    }

    @Override
    public void receive(ChannelEvent event) {
        Channel channel = event.getChannel();
        switch (event.getEvent()) {
            case REQUEST_ENABLE: {
                if (this.isProcessing(channel)) break;
                try {
                    this.startProcessing(new ChannelStartProcessingRequest(event.getChannel()));
                }
                catch (ChannelException ce) {
                    if (channel.getSourceConfiguration() instanceof SourceConfigTuner) {
                        long frequency = ((SourceConfigTuner)channel.getSourceConfiguration()).getFrequency();
                        if (this.mLoggedFrequencies.contains(frequency)) break;
                        this.mLoggedFrequencies.add(frequency);
                        mLog.error("Error starting requested channel [" + channel.getName() + ":" + frequency + "] - " + ce.getMessage());
                        break;
                    }
                    if (channel.getSourceConfiguration() instanceof SourceConfigTunerMultipleFrequency) {
                        List<Long> frequencies = ((SourceConfigTunerMultipleFrequency)channel.getSourceConfiguration()).getFrequencies();
                        if (frequencies.size() <= 0 || this.mLoggedFrequencies.contains(frequencies.get(0))) break;
                        this.mLoggedFrequencies.add(frequencies.get(0));
                        mLog.error("Error starting requested channel [" + channel.getName() + ":" + String.valueOf(frequencies) + "] - " + ce.getMessage());
                        break;
                    }
                    mLog.error("Error starting requested channel [" + channel.getName() + "] - " + ce.getMessage());
                }
                break;
            }
            case REQUEST_DISABLE: 
            case NOTIFICATION_DELETE: {
                if (!channel.isProcessing()) break;
                try {
                    this.stopProcessing(channel);
                }
                catch (ChannelException ce) {
                    mLog.error("Error stopping channel [" + channel.getName() + "] - " + ce.getMessage());
                }
                break;
            }
        }
    }

    public void start(Channel channel) throws ChannelException {
        this.startProcessing(new ChannelStartProcessingRequest(channel));
    }

    @Subscribe
    public void startChannelRequest(ChannelStartProcessingRequest request) {
        block3: {
            if (!this.isProcessing(request.getChannel())) {
                try {
                    this.startProcessing(request);
                }
                catch (ChannelException ce) {
                    if (!request.isPersistentAttempt()) break block3;
                    ScheduledFuture<?> future = ThreadPool.SCHEDULED.schedule(new DelayedChannelStartTask(request), 500L, TimeUnit.MILLISECONDS);
                    this.mDelayedChannelStartTasks.add(future);
                }
            }
        }
    }

    @Subscribe
    public void stopChannelRequest(ChannelStopProcessingRequest request) {
        Channel channel = this.getChannel(request.getTunerChannelSource());
        if (channel != null) {
            try {
                this.stop(channel);
            }
            catch (ChannelException ce) {
                mLog.error("Error stopping channel [" + String.valueOf(channel) + "]", (Throwable)ce);
            }
        }
    }

    public void stop(Channel channel) throws ChannelException {
        this.stopProcessing(channel);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void startProcessing(ChannelStartProcessingRequest request) throws ChannelException {
        Channel channel = request.getChannel();
        if (this.isProcessing(channel)) {
            return;
        }
        Source source = null;
        try {
            source = this.mTunerManager.getSource(channel.getSourceConfiguration(), channel.getDecodeConfiguration().getChannelSpecification());
        }
        catch (SourceException se) {
            mLog.debug("Error obtaining source for channel [" + channel.getName() + "]", (Throwable)se);
        }
        if (source == null) {
            Platform.runLater(() -> channel.setProcessing(false));
            this.mChannelEventBroadcaster.broadcast(new ChannelEvent(channel, ChannelEvent.Event.NOTIFICATION_PROCESSING_START_REJECTED, TUNER_UNAVAILABLE_DESCRIPTION));
            throw new ChannelException("No Tuner Available");
        }
        ProcessingChain processingChain = new ProcessingChain(channel, this.mAliasModel);
        if (request.hasParentDecodeEventHistory()) {
            processingChain.getDecodeEventHistory().addListener(request.getParentDecodeEventHistory());
        } else if (request.hasChildDecodeEventHistory()) {
            request.getChildDecodeEventHistory().addListener(processingChain.getDecodeEventHistory());
        }
        processingChain.getEventBus().register((Object)this);
        this.mChannelEventBroadcaster.addListener(processingChain);
        for (Listener<AudioSegment> listener : this.mAudioSegmentListeners) {
            processingChain.addAudioSegmentListener(listener);
        }
        for (Listener<Object> listener : this.mDecodeEventListeners) {
            processingChain.addDecodeEventListener(listener);
        }
        processingChain.addSourceEventListener(this.mSourceErrorListener);
        processingChain.addChannelEventListener(this);
        processingChain.addFrequencyChangeListener(channel);
        List<Module> modules = DecoderFactory.getModules(this.mChannelMapModel, channel, this.mAliasModel, this.mUserPreferences, request.getTrafficChannelManager());
        processingChain.addModules(modules);
        for (PreloadDataContent<?> preloadDataContent : request.getPreloadDataContents()) {
            processingChain.getEventBus().post(preloadDataContent);
        }
        List<Module> list = this.mEventLogManager.getLoggers(channel);
        if (!list.isEmpty()) {
            processingChain.addModules(list);
        }
        processingChain.addModules(RecorderFactory.getRecorders(this.mUserPreferences, channel));
        processingChain.setSource(source);
        if (channel.isTrafficChannel()) {
            IdentifierUpdateNotification notification;
            if (request.hasChannelDescriptor() && request.hasIdentifierCollection()) {
                void var7_14;
                boolean bl = false;
                while (var7_14 < request.getChannelDescriptor().getTimeslotCount()) {
                    DecoderLogicalChannelNameIdentifier identifier = DecoderLogicalChannelNameIdentifier.create(request.getChannelDescriptor().toString(), request.getChannelDescriptor().getProtocol());
                    notification = new IdentifierUpdateNotification(identifier, IdentifierUpdateNotification.Operation.ADD, (int)var7_14);
                    processingChain.getChannelState().updateChannelStateIdentifiers(notification);
                    for (Identifier scrambleParameters : request.getIdentifierCollection().getIdentifiers(Form.SCRAMBLE_PARAMETERS)) {
                        IdentifierUpdateNotification scrambleNotification = new IdentifierUpdateNotification(scrambleParameters, IdentifierUpdateNotification.Operation.ADD, (int)var7_14);
                        processingChain.getChannelState().updateChannelStateIdentifiers(scrambleNotification);
                    }
                    ++var7_14;
                }
            }
            for (Identifier userIdentifier : request.getIdentifierCollection().getIdentifiers(IdentifierClass.USER)) {
                if (request.getChannelDescriptor().getTimeslotCount() > 1) {
                    notification = new IdentifierUpdateNotification(userIdentifier, IdentifierUpdateNotification.Operation.ADD, request.getIdentifierCollection().getTimeslot());
                    processingChain.getChannelState().updateChannelStateIdentifiers(notification);
                    continue;
                }
                notification = new IdentifierUpdateNotification(userIdentifier, IdentifierUpdateNotification.Operation.ADD, 0);
                processingChain.getChannelState().updateChannelStateIdentifiers(notification);
            }
        }
        if (this.addProcessingChain(channel, processingChain)) {
            processingChain.start();
            if (GraphicsEnvironment.isHeadless()) {
                channel.setProcessing(true);
            } else {
                Platform.runLater(() -> channel.setProcessing(true));
            }
            this.mChannelEventBroadcaster.broadcast(new ChannelEvent(channel, ChannelEvent.Event.NOTIFICATION_PROCESSING_START));
        } else {
            mLog.warn("Channel [" + channel.getName() + "] processing chain not added because it already exists");
            processingChain.removeEventLoggingModules();
            processingChain.removeRecordingModules();
            processingChain.removeFrequencyChangeListener(channel);
            channel.resetFrequencyCorrection();
            this.mChannelEventBroadcaster.broadcast(new ChannelEvent(channel, ChannelEvent.Event.NOTIFICATION_PROCESSING_STOP));
            this.mChannelEventBroadcaster.removeListener(processingChain);
            processingChain.getEventBus().unregister((Object)this);
            processingChain.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addProcessingChain(Channel channel, ProcessingChain processingChain) {
        boolean added = false;
        this.mLock.lock();
        try {
            if (!this.mProcessingChains.containsKey(channel)) {
                added = true;
                this.mProcessingChains.put(channel, processingChain);
                this.getChannelMetadataModel().add(new ChannelAndMetadata(channel, processingChain.getChannelState().getChannelMetadata()));
            }
        }
        finally {
            this.mLock.unlock();
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessingChain removeProcessingChain(Channel channel) {
        ProcessingChain removed = null;
        this.mLock.lock();
        try {
            removed = this.mProcessingChains.remove(channel);
            if (removed != null) {
                for (ChannelMetadata channelMetadata : removed.getChannelState().getChannelMetadata()) {
                    this.getChannelMetadataModel().remove(channelMetadata);
                }
            }
        }
        finally {
            this.mLock.unlock();
        }
        return removed;
    }

    private void stopProcessing(Channel channel) throws ChannelException {
        ProcessingChain processingChain = this.removeProcessingChain(channel);
        if (processingChain != null) {
            if (GraphicsEnvironment.isHeadless()) {
                channel.setProcessing(false);
            } else {
                Platform.runLater(() -> channel.setProcessing(false));
            }
            try {
                processingChain.stop();
                processingChain.removeEventLoggingModules();
                processingChain.removeRecordingModules();
                processingChain.removeFrequencyChangeListener(channel);
                channel.resetFrequencyCorrection();
                this.mChannelEventBroadcaster.broadcast(new ChannelEvent(channel, ChannelEvent.Event.NOTIFICATION_PROCESSING_STOP));
                this.mChannelEventBroadcaster.removeListener(processingChain);
                processingChain.getEventBus().unregister((Object)this);
                processingChain.dispose();
            }
            catch (Exception e) {
                mLog.error("Error during shutdown of processing chain for channel [" + channel.getName() + "}", (Throwable)e);
            }
        }
    }

    public void shutdown() {
        ArrayList delayedTasks = new ArrayList(this.mDelayedChannelStartTasks);
        for (ScheduledFuture scheduledFuture : delayedTasks) {
            scheduledFuture.cancel(true);
            this.mDelayedChannelStartTasks.remove(scheduledFuture);
        }
        ArrayList<Channel> channelsToStop = new ArrayList<Channel>(this.mProcessingChains.keySet());
        for (Channel channel : channelsToStop) {
            try {
                this.stopProcessing(channel);
            }
            catch (ChannelException ce) {
                mLog.error("Error stopping channel [" + channel.getName() + "] - " + ce.getMessage());
            }
        }
    }

    @Subscribe
    public void convertToTrafficChannel(ChannelConversionRequest request) {
        ProcessingChain processingChain = this.mProcessingChains.remove(request.getCurrentChannel());
        if (processingChain != null) {
            processingChain.removeTrafficChannelManager();
            Platform.runLater(() -> {
                request.getCurrentChannel().setProcessing(false);
                request.getTrafficChannel().setProcessing(true);
            });
            this.mProcessingChains.put(request.getTrafficChannel(), processingChain);
            this.mChannelMetadataModel.updateChannelMetadataToChannelMap(processingChain.getChannelState().getChannelMetadata(), request.getTrafficChannel());
            processingChain.channelConfigurationChanged(new ChannelConfigurationChangeNotification(request.getTrafficChannel()));
        } else {
            mLog.warn("Request to convert to traffic channel ignored - no processing chain was found");
        }
    }

    public void addAudioSegmentListener(Listener<AudioSegment> listener) {
        this.mAudioSegmentListeners.add(listener);
    }

    public void removeAudioSegmentListener(Listener<AudioSegment> listener) {
        this.mAudioSegmentListeners.remove(listener);
    }

    public void addDecodeEventListener(Listener<IDecodeEvent> listener) {
        this.mDecodeEventListeners.add(listener);
    }

    public void removeDecodeEventListener(Listener<IDecodeEvent> listener) {
        this.mDecodeEventListeners.remove(listener);
    }

    public void addChannelEventListener(Listener<ChannelEvent> listener) {
        this.mChannelEventBroadcaster.addListener(listener);
    }

    public void removeChannelEventListener(Listener<ChannelEvent> listener) {
        this.mChannelEventBroadcaster.removeListener(listener);
    }

    private class ChannelSourceEventErrorListener
    implements Listener<SourceEvent> {
        private ChannelSourceEventErrorListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(SourceEvent sourceEvent) {
            if (sourceEvent.getEvent() == SourceEvent.Event.NOTIFICATION_ERROR_STATE && sourceEvent.getSource() != null) {
                Channel toShutdown = null;
                ChannelProcessingManager.this.mLock.lock();
                try {
                    for (Map.Entry<Channel, ProcessingChain> entry : ChannelProcessingManager.this.mProcessingChains.entrySet()) {
                        if (!entry.getValue().hasSource(sourceEvent.getSource())) continue;
                        toShutdown = entry.getKey();
                        break;
                    }
                }
                finally {
                    ChannelProcessingManager.this.mLock.unlock();
                }
                if (toShutdown != null) {
                    if (sourceEvent.getEvent() == SourceEvent.Event.NOTIFICATION_ERROR_STATE) {
                        mLog.warn("Channel source error detected - stopping channel [" + toShutdown.getName() + "]");
                    } else {
                        mLog.warn("Source event error - stopping channel [" + toShutdown.getName() + "]");
                    }
                    try {
                        ChannelProcessingManager.this.stopProcessing(toShutdown);
                    }
                    catch (ChannelException ce) {
                        mLog.error("Error stopping channel [" + (toShutdown != null ? toShutdown.getName() : "unknown") + "] with source error - " + ce.getMessage());
                    }
                }
            }
        }
    }

    public class DelayedChannelStartTask
    implements Runnable {
        private ChannelStartProcessingRequest mRequest;

        public DelayedChannelStartTask(ChannelStartProcessingRequest request) {
            this.mRequest = request;
        }

        @Override
        public void run() {
            try {
                ChannelProcessingManager.this.mDelayedChannelStartTasks.remove(this);
                ChannelProcessingManager.this.startChannelRequest(this.mRequest);
            }
            catch (Throwable t) {
                mLog.error("Error executing persistent channel start task");
            }
        }
    }
}

