/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.controller.channel;

import io.github.dsheirer.controller.channel.AutoStartChannelModel;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.util.ThreadPool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelAutoStartFrame
extends JFrame {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelAutoStartFrame.class);
    private Listener<ChannelEvent> mChannelEventListener;
    private List<Channel> mChannels;
    private JLabel mCountdownLabel;
    private JButton mStartButton;
    private JButton mCancelButton;
    private JTable mChannelTable;
    private AtomicBoolean mChannelsStarted = new AtomicBoolean();
    private int mAutoStartTimeoutSeconds;
    private ScheduledFuture<?> mTimerFuture;

    public ChannelAutoStartFrame(Listener<ChannelEvent> listener, List<Channel> channels, UserPreferences userPreferences) {
        this.mChannelEventListener = listener;
        this.mChannels = channels;
        this.mAutoStartTimeoutSeconds = userPreferences.getApplicationPreference().getChannelAutoStartTimeout();
        this.init();
        EventQueue.invokeLater(() -> {
            this.setVisible(true);
            this.toFront();
            this.startTimer();
        });
    }

    private void init() {
        this.setTitle("Auto-Start Channels");
        this.setSize(new Dimension(400, 300));
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                mLog.info("Channel auto-start canceled by user - window closed");
                ChannelAutoStartFrame.this.stopTimer();
                super.windowClosing(event);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[grow,fill][grow,fill]", "[][][grow,fill][]"));
        panel.add((Component)new JLabel("The following channels will be automatically"), "span");
        this.mCountdownLabel = new JLabel(this.getCountdownText(this.mAutoStartTimeoutSeconds));
        panel.add((Component)this.mCountdownLabel, "span");
        panel.add((Component)new JScrollPane(this.getChannelTable()), "span");
        this.mStartButton = new JButton("Start Now");
        this.mStartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mLog.info("Starting [" + ChannelAutoStartFrame.this.mChannels.size() + "] channels now - user invoked");
                ChannelAutoStartFrame.this.startChannels();
                ChannelAutoStartFrame.this.stopTimer();
            }
        });
        panel.add(this.mStartButton);
        this.mCancelButton = new JButton("Cancel");
        this.mCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mLog.info("Channel auto-start canceled by user");
                ChannelAutoStartFrame.this.stopTimer();
            }
        });
        panel.add(this.mCancelButton);
        this.setContentPane(panel);
    }

    private String getCountdownText(int value) {
        return "started in: " + value + " seconds.";
    }

    private void updateCountdownText(final int value) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChannelAutoStartFrame.this.mCountdownLabel.setText(ChannelAutoStartFrame.this.getCountdownText(value));
            }
        });
    }

    private JTable getChannelTable() {
        if (this.mChannelTable == null) {
            AutoStartChannelModel model = new AutoStartChannelModel(this.mChannels);
            this.mChannelTable = new JTable(model);
        }
        return this.mChannelTable;
    }

    private void startChannels() {
        if (this.mChannelsStarted.compareAndSet(false, true) && this.mChannelEventListener != null) {
            for (Channel channel : this.mChannels) {
                this.mChannelEventListener.receive(new ChannelEvent(channel, ChannelEvent.Event.REQUEST_ENABLE));
            }
        }
    }

    private void startTimer() {
        if (this.mTimerFuture == null) {
            this.mTimerFuture = ThreadPool.SCHEDULED.scheduleAtFixedRate(new CountdownTimer(), 0L, 1L, TimeUnit.SECONDS);
        }
    }

    private void stopTimer() {
        if (this.mTimerFuture != null) {
            this.mTimerFuture.cancel(true);
            this.mTimerFuture = null;
        }
        EventQueue.invokeLater(() -> this.dispose());
    }

    public class CountdownTimer
    implements Runnable {
        private int mCount;

        public CountdownTimer() {
            this.mCount = ChannelAutoStartFrame.this.mAutoStartTimeoutSeconds;
        }

        @Override
        public void run() {
            if (this.mCount >= 0) {
                ChannelAutoStartFrame.this.updateCountdownText(this.mCount);
                --this.mCount;
            } else {
                mLog.info("Starting [" + ChannelAutoStartFrame.this.mChannels.size() + "] now - timer invoked");
                ChannelAutoStartFrame.this.startChannels();
                ChannelAutoStartFrame.this.stopTimer();
            }
        }
    }
}

