/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.controller.channel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.github.dsheirer.controller.config.Configuration;
import io.github.dsheirer.module.decode.DecoderFactory;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.config.AuxDecodeConfiguration;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.log.EventLogType;
import io.github.dsheirer.module.log.config.EventLogConfiguration;
import io.github.dsheirer.record.RecorderType;
import io.github.dsheirer.record.config.RecordConfiguration;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceType;
import io.github.dsheirer.source.config.SourceConfigFactory;
import io.github.dsheirer.source.config.SourceConfigRecording;
import io.github.dsheirer.source.config.SourceConfigTuner;
import io.github.dsheirer.source.config.SourceConfigTunerMultipleFrequency;
import io.github.dsheirer.source.config.SourceConfiguration;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import java.beans.Transient;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JacksonXmlRootElement(localName="channel")
public class Channel
extends Configuration
implements Listener<SourceEvent> {
    private static final Logger mLog = LoggerFactory.getLogger(Channel.class);
    private static int UNIQUE_ID = 0;
    private DecodeConfiguration mDecodeConfiguration = DecoderFactory.getDefaultDecodeConfiguration();
    private AuxDecodeConfiguration mAuxDecodeConfiguration = new AuxDecodeConfiguration();
    private SourceConfiguration mSourceConfiguration = SourceConfigFactory.getDefaultSourceConfiguration();
    private EventLogConfiguration mEventLogConfiguration = new EventLogConfiguration();
    private RecordConfiguration mRecordConfiguration = new RecordConfiguration();
    private StringProperty mAliasListName = new SimpleStringProperty();
    private StringProperty mSystem = new SimpleStringProperty();
    private StringProperty mSite = new SimpleStringProperty();
    private StringProperty mName = new SimpleStringProperty();
    private ObservableList<Long> mFrequencyList;
    private BooleanProperty mProcessing = new SimpleBooleanProperty();
    private BooleanProperty mAutoStart = new SimpleBooleanProperty();
    private IntegerProperty mAutoStartOrder = new SimpleIntegerProperty();
    private boolean mSelected;
    private TunerChannel mTunerChannel = null;
    private ChannelType mChannelType = ChannelType.STANDARD;
    private int mChannelID = UNIQUE_ID++;
    private int mChannelFrequencyCorrection = 0;

    public Channel(String channelName, ChannelType channelType) {
        this(channelName);
        this.mChannelType = channelType;
    }

    public Channel(String channelName) {
        this();
        this.mName.set((Object)channelName);
    }

    public Channel() {
    }

    public Channel copyOf() {
        Channel channel = new Channel((String)this.mName.get());
        channel.setSystem((String)this.mSystem.get());
        channel.setSite((String)this.mSite.get());
        channel.setAliasListName((String)this.mAliasListName.get());
        channel.setAutoStart(this.mAutoStart.get());
        channel.setAutoStartOrder(this.mAutoStartOrder.get());
        AuxDecodeConfiguration auxCopy = new AuxDecodeConfiguration();
        if (this.getAuxDecodeConfiguration() != null) {
            for (DecoderType decoderType : this.getAuxDecodeConfiguration().getAuxDecoders()) {
                auxCopy.addAuxDecoder(decoderType);
            }
        }
        channel.setAuxDecodeConfiguration(auxCopy);
        channel.setDecodeConfiguration(DecoderFactory.copy(this.mDecodeConfiguration));
        EventLogConfiguration logCopy = new EventLogConfiguration();
        if (this.mEventLogConfiguration != null) {
            for (EventLogType logType : this.mEventLogConfiguration.getLoggers()) {
                logCopy.addLogger(logType);
            }
        }
        channel.setEventLogConfiguration(logCopy);
        RecordConfiguration recordConfiguration = new RecordConfiguration();
        if (this.mRecordConfiguration != null) {
            for (RecorderType recordType : this.mRecordConfiguration.getRecorders()) {
                recordConfiguration.addRecorder(recordType);
            }
        }
        channel.setRecordConfiguration(recordConfiguration);
        channel.setSourceConfiguration(SourceConfigFactory.copy(this.mSourceConfiguration));
        return channel;
    }

    @JsonIgnore
    public String getShortTitle() {
        StringBuilder sb = new StringBuilder();
        if (this.getSystem() != null) {
            if (this.getSystem().length() > 10) {
                sb.append(this.getSystem().substring(0, 10)).append("..");
            } else {
                sb.append(this.getSystem());
            }
        } else {
            sb.append("No System");
        }
        sb.append("/");
        if (this.getSite() != null) {
            if (this.getSite().length() > 10) {
                sb.append(this.getSite().substring(0, 10)).append("..");
            } else {
                sb.append(this.getSite());
            }
        } else {
            sb.append("No Site");
        }
        sb.append("/");
        if (this.getName() != null) {
            if (this.getName().length() > 10) {
                sb.append(this.getName().substring(0, 10)).append("..");
            } else {
                sb.append(this.getName());
            }
        } else {
            sb.append("No Channel");
        }
        return sb.toString();
    }

    private void updateFrequencies() {
        this.getFrequencyList().clear();
        if (this.mSourceConfiguration instanceof SourceConfigTuner) {
            this.getFrequencyList().add((Object)((SourceConfigTuner)this.mSourceConfiguration).getFrequency());
        } else if (this.mSourceConfiguration instanceof SourceConfigTunerMultipleFrequency) {
            this.getFrequencyList().addAll(((SourceConfigTunerMultipleFrequency)this.mSourceConfiguration).getFrequencies());
        }
    }

    public StringProperty aliasListNameProperty() {
        return this.mAliasListName;
    }

    public StringProperty systemProperty() {
        return this.mSystem;
    }

    public StringProperty siteProperty() {
        return this.mSite;
    }

    public StringProperty nameProperty() {
        return this.mName;
    }

    public BooleanProperty processingProperty() {
        return this.mProcessing;
    }

    public BooleanProperty autoStartProperty() {
        return this.mAutoStart;
    }

    public IntegerProperty autoStartOrderProperty() {
        return this.mAutoStartOrder;
    }

    @JsonIgnore
    public int getChannelID() {
        return this.mChannelID;
    }

    @JsonIgnore
    @Transient
    public ObservableList<Long> getFrequencyList() {
        if (this.mFrequencyList == null) {
            this.mFrequencyList = FXCollections.observableArrayList();
            this.updateFrequencies();
        }
        return this.mFrequencyList;
    }

    @JsonIgnore
    public boolean isSelected() {
        return this.mSelected;
    }

    void setSelected(boolean selected) {
        this.mSelected = selected;
    }

    @JsonIgnore
    public ChannelType getChannelType() {
        return this.mChannelType;
    }

    @JsonIgnore
    public boolean isTrafficChannel() {
        return this.mChannelType == ChannelType.TRAFFIC;
    }

    @JsonIgnore
    public boolean isStandardChannel() {
        return this.mChannelType == ChannelType.STANDARD;
    }

    @JacksonXmlProperty(isAttribute=true, localName="system")
    public String getSystem() {
        return (String)this.mSystem.get();
    }

    public void setSystem(String system) {
        this.mSystem.set((Object)system);
    }

    public boolean hasSystem() {
        return this.mSystem != null && this.mSystem.get() != null;
    }

    @JacksonXmlProperty(isAttribute=true, localName="site")
    public String getSite() {
        return (String)this.mSite.get();
    }

    public void setSite(String site) {
        this.mSite.set((Object)site);
    }

    public boolean hasSite() {
        return this.mSite != null && this.mSite.get() != null;
    }

    @JacksonXmlProperty(isAttribute=true, localName="name")
    public String getName() {
        return (String)this.mName.get();
    }

    public void setName(String name) {
        this.mName.set((Object)name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.hasSystem() ? this.getSystem() : "SYSTEM");
        sb.append("_");
        sb.append(this.hasSite() ? this.getSite() : "SITE");
        sb.append("_");
        sb.append(this.getName());
        sb.append("_");
        sb.append(this.getChannelID());
        return sb.toString();
    }

    @JsonIgnore
    public boolean isProcessing() {
        return this.mProcessing.get();
    }

    void setProcessing(boolean processing) {
        this.mProcessing.set(processing);
    }

    @JacksonXmlProperty(isAttribute=true, localName="enabled")
    public boolean getAutoStart() {
        return this.mAutoStart.get();
    }

    @JsonIgnore
    public boolean isAutoStart() {
        return this.mAutoStart.get();
    }

    public void setAutoStart(boolean autoStart) {
        this.mAutoStart.set(autoStart);
    }

    @JacksonXmlProperty(isAttribute=true, localName="order")
    public Integer getAutoStartOrder() {
        return this.mAutoStartOrder.get();
    }

    public void setAutoStartOrder(Integer order) {
        if (order != null) {
            this.mAutoStartOrder.set(order.intValue());
        } else {
            this.mAutoStartOrder.setValue(null);
        }
    }

    @JsonIgnore
    public boolean hasAutoStartOrder() {
        return this.mAutoStartOrder != null && this.mAutoStartOrder.getValue() != null;
    }

    @JacksonXmlProperty(isAttribute=false, localName="alias_list_name")
    public String getAliasListName() {
        return (String)this.mAliasListName.get();
    }

    public void setAliasListName(String name) {
        this.mAliasListName.set((Object)name);
    }

    @JacksonXmlProperty(isAttribute=false, localName="decode_configuration")
    public DecodeConfiguration getDecodeConfiguration() {
        return this.mDecodeConfiguration;
    }

    public void setDecodeConfiguration(DecodeConfiguration config) {
        if (config != null) {
            this.mDecodeConfiguration = config;
        }
    }

    @JacksonXmlProperty(isAttribute=false, localName="aux_decode_configuration")
    public AuxDecodeConfiguration getAuxDecodeConfiguration() {
        return this.mAuxDecodeConfiguration;
    }

    public void setAuxDecodeConfiguration(AuxDecodeConfiguration config) {
        if (config != null) {
            this.mAuxDecodeConfiguration = config;
        }
    }

    @JacksonXmlProperty(isAttribute=false, localName="source_configuration")
    public SourceConfiguration getSourceConfiguration() {
        return this.mSourceConfiguration;
    }

    public void setSourceConfiguration(SourceConfiguration config) {
        if (config != null) {
            this.mSourceConfiguration = config;
        }
        this.updateFrequencies();
        this.mTunerChannel = null;
    }

    @JacksonXmlProperty(isAttribute=false, localName="event_log_configuration")
    public EventLogConfiguration getEventLogConfiguration() {
        return this.mEventLogConfiguration;
    }

    public void setEventLogConfiguration(EventLogConfiguration config) {
        if (config != null) {
            this.mEventLogConfiguration = config;
        }
    }

    @JacksonXmlProperty(isAttribute=false, localName="record_configuration")
    public RecordConfiguration getRecordConfiguration() {
        return this.mRecordConfiguration;
    }

    public void setRecordConfiguration(RecordConfiguration config) {
        if (config != null) {
            this.mRecordConfiguration = config;
        }
    }

    @JsonIgnore
    public TunerChannel getTunerChannel() {
        if (this.mTunerChannel == null) {
            if (this.mSourceConfiguration.getSourceType() == SourceType.TUNER) {
                SourceConfigTuner config = (SourceConfigTuner)this.mSourceConfiguration;
                this.mTunerChannel = new TunerChannel(config.getFrequency(), this.mDecodeConfiguration.getChannelSpecification().getBandwidth());
            } else if (this.mSourceConfiguration.getSourceType() == SourceType.RECORDING) {
                SourceConfigRecording config = (SourceConfigRecording)this.mSourceConfiguration;
                this.mTunerChannel = new TunerChannel(config.getFrequency(), this.mDecodeConfiguration.getChannelSpecification().getBandwidth());
            }
        }
        return this.mTunerChannel;
    }

    public boolean isWithin(long minimum, long maximum) {
        TunerChannel tunerChannel = this.getTunerChannel();
        return tunerChannel != null && tunerChannel.overlaps(minimum, maximum);
    }

    @Override
    public void receive(SourceEvent event) {
        if (event.getEvent() == SourceEvent.Event.NOTIFICATION_CHANNEL_FREQUENCY_CORRECTION_CHANGE) {
            this.mChannelFrequencyCorrection = event.getValue().intValue();
        }
    }

    @JsonIgnore
    public int getChannelFrequencyCorrection() {
        return this.mChannelFrequencyCorrection;
    }

    public void resetFrequencyCorrection() {
        this.mChannelFrequencyCorrection = 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel channel = (Channel)o;
        return this.getChannelID() == channel.getChannelID();
    }

    public int hashCode() {
        return Objects.hash(this.getChannelID());
    }

    /*
     * Exception decompiling
     */
    public static Callback<Channel, Observable[]> extractor() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static enum ChannelType {
        STANDARD,
        TRAFFIC;

    }
}

