/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.state;

import io.github.dsheirer.audio.squelch.ISquelchStateProvider;
import io.github.dsheirer.audio.squelch.SquelchState;
import io.github.dsheirer.audio.squelch.SquelchStateEvent;
import io.github.dsheirer.channel.state.IStateMachineListener;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.sample.Listener;

public class StateMonitoringSquelchController
implements IStateMachineListener,
ISquelchStateProvider {
    private boolean mSquelchLocked;
    private SquelchState mSquelchState = SquelchState.SQUELCH;
    private Listener<SquelchStateEvent> mSquelchStateListener;
    private int mTimeslot;

    public StateMonitoringSquelchController(int timeslot) {
        this.mTimeslot = timeslot;
    }

    @Override
    public void setSquelchStateListener(Listener<SquelchStateEvent> listener) {
        this.mSquelchStateListener = listener;
    }

    @Override
    public void removeSquelchStateListener() {
        this.mSquelchStateListener = null;
    }

    public void setSquelchLock(boolean locked) {
        this.mSquelchLocked = locked;
        this.setSquelchState(this.mSquelchLocked ? SquelchState.UNSQUELCH : SquelchState.SQUELCH);
    }

    private void setSquelchState(SquelchState squelchState) {
        if (this.mSquelchState != squelchState) {
            this.mSquelchState = squelchState;
            if (this.mSquelchStateListener != null) {
                this.mSquelchStateListener.receive(new SquelchStateEvent(squelchState, this.mTimeslot));
            }
        }
    }

    @Override
    public void stateChanged(State state, int timeslot) {
        if (!this.mSquelchLocked) {
            if (state == State.CALL) {
                this.setSquelchState(SquelchState.UNSQUELCH);
            } else {
                this.setSquelchState(SquelchState.SQUELCH);
            }
        }
    }
}

