/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.state;

import io.github.dsheirer.channel.state.IStateMachineListener;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.identifier.decoder.ChannelStateIdentifier;
import io.github.dsheirer.sample.Listener;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachine {
    private static final Logger mLog = LoggerFactory.getLogger(StateMachine.class);
    protected State mState = State.IDLE;
    protected long mFadeTimeout;
    protected long mFadeTimeoutBufferMilliseconds = 0L;
    protected long mEndTimeout;
    protected long mEndTimeoutBufferMilliseconds = 0L;
    private int mTimeslot;
    private EnumSet<State> mActiveStates;
    private Channel.ChannelType mChannelType = Channel.ChannelType.STANDARD;
    private List<IStateMachineListener> mStateMachineListeners = new ArrayList<IStateMachineListener>();
    private Listener<IdentifierUpdateNotification> mIdentifierUpdateListener;

    public StateMachine(int timeslot, EnumSet<State> activeStates) {
        this.mTimeslot = timeslot;
        this.mActiveStates = activeStates;
    }

    public void addListener(IStateMachineListener listener) {
        this.mStateMachineListeners.add(listener);
    }

    public void removeListener(IStateMachineListener listener) {
        this.mStateMachineListeners.remove(listener);
    }

    public void setIdentifierUpdateListener(Listener<IdentifierUpdateNotification> listener) {
        this.mIdentifierUpdateListener = listener;
    }

    public void setChannelType(Channel.ChannelType channelType) {
        this.mChannelType = channelType;
    }

    public void checkState() {
        if (this.mActiveStates.contains((Object)this.mState) && this.mFadeTimeout <= System.currentTimeMillis()) {
            this.setState(State.FADE);
        } else if (this.mState == State.FADE && this.mEndTimeout <= System.currentTimeMillis()) {
            this.setState(State.TEARDOWN);
        }
    }

    public State getState() {
        return this.mState;
    }

    public void setState(State state) {
        if (state == this.mState) {
            if (this.mActiveStates.contains((Object)state)) {
                this.updateFadeTimeout();
            }
        } else if (this.mState.canChangeTo(state)) {
            if (this.mActiveStates.contains((Object)state)) {
                this.updateFadeTimeout();
            }
            switch (state) {
                case ACTIVE: {
                    this.mState = state;
                    this.broadcast(ChannelStateIdentifier.ACTIVE);
                    break;
                }
                case CONTROL: {
                    if (this.mChannelType != Channel.ChannelType.STANDARD) break;
                    this.mState = state;
                    this.broadcast(ChannelStateIdentifier.CONTROL);
                    break;
                }
                case DATA: {
                    this.mState = state;
                    this.broadcast(ChannelStateIdentifier.DATA);
                    break;
                }
                case ENCRYPTED: {
                    this.mState = state;
                    this.broadcast(ChannelStateIdentifier.ENCRYPTED);
                    break;
                }
                case CALL: {
                    this.mState = state;
                    this.broadcast(ChannelStateIdentifier.CALL);
                    break;
                }
                case FADE: {
                    this.mState = state;
                    this.broadcast(ChannelStateIdentifier.FADE);
                    break;
                }
                case IDLE: {
                    this.mState = state;
                    this.broadcast(ChannelStateIdentifier.IDLE);
                    break;
                }
                case TEARDOWN: {
                    this.mState = state;
                    this.broadcast(ChannelStateIdentifier.TEARDOWN);
                    break;
                }
                case RESET: {
                    this.mState = State.RESET;
                    this.broadcast(ChannelStateIdentifier.RESET);
                    break;
                }
            }
            if (this.mState == state) {
                for (IStateMachineListener listener : this.mStateMachineListeners) {
                    listener.stateChanged(this.mState, this.mTimeslot);
                }
            }
        }
    }

    private void broadcast(ChannelStateIdentifier channelStateIdentifier) {
        if (this.mIdentifierUpdateListener != null) {
            this.mIdentifierUpdateListener.receive(new IdentifierUpdateNotification(channelStateIdentifier, IdentifierUpdateNotification.Operation.ADD, this.mTimeslot));
        }
    }

    private void updateFadeTimeout() {
        this.mFadeTimeout = System.currentTimeMillis() + this.mFadeTimeoutBufferMilliseconds;
    }

    public void setFadeTimeout(long timeout) {
        this.mFadeTimeout = timeout;
    }

    public long getFadeTimeout() {
        return this.mFadeTimeout;
    }

    public void setFadeTimeoutBufferMilliseconds(long buffer) {
        this.mFadeTimeoutBufferMilliseconds = buffer;
        this.updateFadeTimeout();
    }

    private void updateEndTimeout() {
        this.mEndTimeout = System.currentTimeMillis() + this.mEndTimeoutBufferMilliseconds;
    }

    public void setEndTimeoutBufferMilliseconds(long buffer) {
        this.mEndTimeoutBufferMilliseconds = buffer;
        this.updateEndTimeout();
    }

    public void setEndTimeout(long endTimeout) {
        this.mEndTimeout = endTimeout;
    }

    public long getEndTimeout() {
        return this.mEndTimeout;
    }
}

