/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.state;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.squelch.SquelchStateEvent;
import io.github.dsheirer.channel.metadata.ChannelMetadata;
import io.github.dsheirer.channel.state.AbstractChannelState;
import io.github.dsheirer.channel.state.ChangeChannelTimeoutEvent;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.DecoderStateNotificationEventCache;
import io.github.dsheirer.channel.state.IDecoderStateEventListener;
import io.github.dsheirer.channel.state.IStateMachineListener;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.channel.state.StateMachine;
import io.github.dsheirer.channel.state.StateMonitoringSquelchController;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelConfigurationChangeNotification;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierUpdateListener;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.identifier.configuration.AliasListConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.ChannelNameConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.DecoderTypeConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.FrequencyConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.SiteConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.SystemConfigurationIdentifier;
import io.github.dsheirer.identifier.decoder.ChannelStateIdentifier;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.config.WithCallTimeout;
import io.github.dsheirer.module.decode.event.IDecodeEvent;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.ISourceEventListener;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceType;
import io.github.dsheirer.source.config.SourceConfigTuner;
import io.github.dsheirer.source.config.SourceConfigTunerMultipleFrequency;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleChannelState
extends AbstractChannelState
implements IDecoderStateEventListener,
ISourceEventListener,
IdentifierUpdateListener,
IStateMachineListener {
    private static final Logger mLog = LoggerFactory.getLogger(SingleChannelState.class);
    public static final long FADE_TIMEOUT_DELAY = 1200L;
    public static final long RESET_TIMEOUT_DELAY = 2000L;
    private MutableIdentifierCollection mIdentifierCollection = new MutableIdentifierCollection();
    private IdentifierUpdateNotificationProxy mIdentifierUpdateNotificationProxy = new IdentifierUpdateNotificationProxy(this);
    private DecoderStateEventReceiver mDecoderStateEventReceiver = new DecoderStateEventReceiver();
    private SourceEventListener mInternalSourceEventListener;
    private ChannelMetadata mChannelMetadata;
    private StateMachine mStateMachine = new StateMachine(0, State.SINGLE_CHANNEL_ACTIVE_STATES);
    private StateMonitoringSquelchController mSquelchController = new StateMonitoringSquelchController(0);
    private DecoderStateNotificationEventCache mStateNotificationCache = new DecoderStateNotificationEventCache();

    public SingleChannelState(Channel channel, AliasModel aliasModel) {
        super(channel);
        this.mChannelMetadata = new ChannelMetadata(aliasModel);
        this.mIdentifierCollection.setIdentifierUpdateListener(this.mIdentifierUpdateNotificationProxy);
        this.createConfigurationIdentifiers(channel);
        this.mStateMachine.addListener(this);
        this.mStateMachine.addListener(this.mSquelchController);
        this.mStateMachine.setIdentifierUpdateListener(this.mIdentifierCollection);
        this.mStateMachine.setEndTimeoutBufferMilliseconds(2000L);
        this.configureChannelType(channel);
    }

    private void configureChannelType(Channel channel) {
        this.mStateMachine.setChannelType(this.getChannel().getChannelType());
        if (channel.isStandardChannel()) {
            this.mStateMachine.setFadeTimeoutBufferMilliseconds(1200L);
        } else {
            DecodeConfiguration decodeConfig = channel.getDecodeConfiguration();
            int fadeTimeoutSeconds = decodeConfig instanceof WithCallTimeout ? ((WithCallTimeout)((Object)decodeConfig)).getCallTimeoutSeconds() : 45;
            this.mStateMachine.setFadeTimeoutBufferMilliseconds(fadeTimeoutSeconds * 1000);
        }
    }

    @Subscribe
    public void channelConfigurationChanged(ChannelConfigurationChangeNotification notification) {
        this.updateChannelConfiguration(notification.getChannel());
        this.configureChannelType(notification.getChannel());
        this.createConfigurationIdentifiers(notification.getChannel());
    }

    @Override
    public void stateChanged(State state, int timeslot) {
        ChannelStateIdentifier stateIdentifier = ChannelStateIdentifier.get(state);
        this.mIdentifierCollection.update(stateIdentifier);
        this.mChannelMetadata.receive(new IdentifierUpdateNotification(stateIdentifier, IdentifierUpdateNotification.Operation.ADD, timeslot));
        switch (state) {
            case IDLE: {
                this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.REQUEST_RESET, State.IDLE));
                break;
            }
            case RESET: {
                this.reset();
                this.mStateMachine.setState(State.IDLE);
                break;
            }
            case TEARDOWN: {
                if (this.getChannel().isTrafficChannel()) {
                    this.broadcast(new ChannelEvent(this.getChannel(), ChannelEvent.Event.REQUEST_DISABLE));
                    break;
                }
                this.mStateMachine.setState(State.RESET);
            }
        }
    }

    @Override
    protected void checkState() {
        this.mStateMachine.checkState();
    }

    @Override
    public void setIdentifierUpdateListener(Listener<IdentifierUpdateNotification> listener) {
        this.mIdentifierUpdateNotificationProxy.setListener(listener);
    }

    @Override
    public void removeIdentifierUpdateListener() {
        this.mIdentifierUpdateNotificationProxy.removeListener();
    }

    @Override
    public void setSquelchStateListener(Listener<SquelchStateEvent> listener) {
        this.mSquelchController.setSquelchStateListener(listener);
    }

    @Override
    public void removeSquelchStateListener() {
        this.mSquelchController.removeSquelchStateListener();
    }

    private void createConfigurationIdentifiers(Channel channel) {
        List<Long> frequencies;
        this.mIdentifierCollection.update(DecoderTypeConfigurationIdentifier.create(channel.getDecodeConfiguration().getDecoderType()));
        if (channel.hasSystem()) {
            this.mIdentifierCollection.update(SystemConfigurationIdentifier.create(channel.getSystem()));
        }
        if (channel.hasSite()) {
            this.mIdentifierCollection.update(SiteConfigurationIdentifier.create(channel.getSite()));
        }
        if (channel.getName() != null && !channel.getName().isEmpty()) {
            this.mIdentifierCollection.update(ChannelNameConfigurationIdentifier.create(channel.getName()));
        }
        if (channel.getAliasListName() != null && !channel.getAliasListName().isEmpty()) {
            this.mIdentifierCollection.update(AliasListConfigurationIdentifier.create(channel.getAliasListName()));
        }
        if (channel.getSourceConfiguration().getSourceType() == SourceType.TUNER) {
            long frequency = ((SourceConfigTuner)channel.getSourceConfiguration()).getFrequency();
            this.mIdentifierCollection.update(FrequencyConfigurationIdentifier.create(frequency));
        } else if (channel.getSourceConfiguration().getSourceType() == SourceType.TUNER_MULTIPLE_FREQUENCIES && (frequencies = ((SourceConfigTunerMultipleFrequency)channel.getSourceConfiguration()).getFrequencies()).size() > 0) {
            this.mIdentifierCollection.update(FrequencyConfigurationIdentifier.create(frequencies.get(0)));
        }
    }

    @Override
    public Listener<IdentifierUpdateNotification> getIdentifierUpdateListener() {
        return this.mChannelMetadata;
    }

    @Override
    public void updateChannelStateIdentifiers(IdentifierUpdateNotification notification) {
        this.mIdentifierCollection.receive(notification);
        this.mChannelMetadata.receive(notification);
    }

    @Override
    public List<ChannelMetadata> getChannelMetadata() {
        return Collections.singletonList(this.mChannelMetadata);
    }

    @Override
    public void reset() {
        this.mStateMachine.setState(State.RESET);
        this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.REQUEST_RESET, State.IDLE));
        this.mIdentifierCollection.remove(IdentifierClass.USER);
        this.sourceOverflow(false);
    }

    @Override
    public void start() {
        this.mIdentifierCollection.broadcastIdentifiers();
        if (this.getChannel().isTrafficChannel()) {
            this.mStateMachine.setState(State.ACTIVE);
        }
    }

    @Override
    public void stop() {
        this.mSquelchController.setSquelchLock(false);
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        if (this.mInternalSourceEventListener == null) {
            this.mInternalSourceEventListener = new SourceEventListener();
        }
        return this.mInternalSourceEventListener;
    }

    protected void broadcast(SourceEvent sourceEvent) {
        if (this.mExternalSourceEventListener != null) {
            this.mExternalSourceEventListener.receive(sourceEvent);
        }
    }

    protected void broadcast(IDecodeEvent event) {
        if (this.mDecodeEventListener != null) {
            this.mDecodeEventListener.receive(event);
        }
    }

    private void broadcast(ChannelEvent channelEvent) {
        if (this.mChannelEventListener != null) {
            this.mChannelEventListener.receive(channelEvent);
        }
    }

    protected void broadcast(DecoderStateEvent event) {
        if (this.mDecoderStateListener != null) {
            this.mDecoderStateListener.receive(event);
        }
    }

    @Override
    public Listener<DecoderStateEvent> getDecoderStateListener() {
        return this.mDecoderStateEventReceiver;
    }

    public class IdentifierUpdateNotificationProxy
    implements Listener<IdentifierUpdateNotification> {
        private Listener<IdentifierUpdateNotification> mIdentifierUpdateNotificationListener;

        public IdentifierUpdateNotificationProxy(SingleChannelState this$0) {
        }

        @Override
        public void receive(IdentifierUpdateNotification identifierUpdateNotification) {
            if (this.mIdentifierUpdateNotificationListener != null) {
                this.mIdentifierUpdateNotificationListener.receive(identifierUpdateNotification);
            }
        }

        public void setListener(Listener<IdentifierUpdateNotification> listener) {
            this.mIdentifierUpdateNotificationListener = listener;
        }

        public void removeListener() {
            this.mIdentifierUpdateNotificationListener = null;
        }
    }

    public class DecoderStateEventReceiver
    implements Listener<DecoderStateEvent> {
        @Override
        public void receive(DecoderStateEvent event) {
            if (event.getSource() != this) {
                switch (event.getEvent()) {
                    case REQUEST_ALWAYS_UNSQUELCH: {
                        SingleChannelState.this.mSquelchController.setSquelchLock(true);
                        break;
                    }
                    case REQUEST_CHANGE_CALL_TIMEOUT: {
                        if (event instanceof ChangeChannelTimeoutEvent) {
                            ChangeChannelTimeoutEvent timeout = (ChangeChannelTimeoutEvent)event;
                            SingleChannelState.this.mStateMachine.setFadeTimeoutBufferMilliseconds(timeout.getCallTimeoutMilliseconds());
                        }
                    }
                    case CONTINUATION: 
                    case DECODE: 
                    case START: {
                        if (!State.SINGLE_CHANNEL_ACTIVE_STATES.contains((Object)event.getState())) break;
                        SingleChannelState.this.mStateMachine.setState(event.getState());
                        SingleChannelState.this.broadcast(SingleChannelState.this.mStateNotificationCache.getStateNotificationEvent(event.getState(), event.getTimeslot()));
                        break;
                    }
                    case END: {
                        if (SingleChannelState.this.getChannel().isTrafficChannel()) {
                            SingleChannelState.this.mStateMachine.setState(State.TEARDOWN);
                            SingleChannelState.this.broadcast(SingleChannelState.this.mStateNotificationCache.getStateNotificationEvent(State.TEARDOWN, event.getTimeslot()));
                            break;
                        }
                        SingleChannelState.this.mStateMachine.setState(State.FADE);
                        SingleChannelState.this.broadcast(SingleChannelState.this.mStateNotificationCache.getStateNotificationEvent(State.FADE, event.getTimeslot()));
                        break;
                    }
                    case REQUEST_RESET: {
                        break;
                    }
                }
            }
        }
    }

    public class SourceEventListener
    implements Listener<SourceEvent> {
        @Override
        public void receive(SourceEvent sourceEvent) {
            switch (sourceEvent.getEvent()) {
                case NOTIFICATION_FREQUENCY_CHANGE: {
                    long frequency = sourceEvent.getValue().longValue();
                    SingleChannelState.this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.NOTIFICATION_SOURCE_FREQUENCY, SingleChannelState.this.mStateMachine.getState(), frequency));
                    SingleChannelState.this.mIdentifierUpdateNotificationProxy.receive(new IdentifierUpdateNotification(FrequencyConfigurationIdentifier.create(frequency), IdentifierUpdateNotification.Operation.SILENT_ADD, 0));
                    break;
                }
                case NOTIFICATION_MEASURED_FREQUENCY_ERROR: {
                    if (!State.SINGLE_CHANNEL_ACTIVE_STATES.contains((Object)SingleChannelState.this.mStateMachine.getState())) break;
                    SingleChannelState.this.broadcast(SourceEvent.frequencyErrorMeasurementSyncLocked(sourceEvent.getValue().longValue(), SingleChannelState.this.getChannel().getChannelType().name()));
                }
            }
        }
    }
}

