/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.state;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.squelch.SquelchStateEvent;
import io.github.dsheirer.channel.metadata.ChannelMetadata;
import io.github.dsheirer.channel.state.AbstractChannelState;
import io.github.dsheirer.channel.state.ChangeChannelTimeoutEvent;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.DecoderStateNotificationEventCache;
import io.github.dsheirer.channel.state.IDecoderStateEventListener;
import io.github.dsheirer.channel.state.IStateMachineListener;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.channel.state.StateMachine;
import io.github.dsheirer.channel.state.StateMonitoringSquelchController;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelConfigurationChangeNotification;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierUpdateListener;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.identifier.configuration.AliasListConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.ChannelNameConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.DecoderTypeConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.FrequencyConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.SiteConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.SystemConfigurationIdentifier;
import io.github.dsheirer.identifier.decoder.ChannelStateIdentifier;
import io.github.dsheirer.module.decode.event.IDecodeEvent;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.ISourceEventListener;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceType;
import io.github.dsheirer.source.config.SourceConfigTuner;
import io.github.dsheirer.source.config.SourceConfigTunerMultipleFrequency;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiChannelState
extends AbstractChannelState
implements IDecoderStateEventListener,
ISourceEventListener,
IdentifierUpdateListener,
IStateMachineListener {
    private static final Logger mLog = LoggerFactory.getLogger(MultiChannelState.class);
    public static final long FADE_TIMEOUT_DELAY = 1200L;
    public static final long RESET_TIMEOUT_DELAY = 2000L;
    private IdentifierUpdateNotificationProxy mIdentifierUpdateNotificationProxy = new IdentifierUpdateNotificationProxy(this);
    private DecoderStateEventReceiver mDecoderStateEventReceiver = new DecoderStateEventReceiver();
    private SourceEventListener mInternalSourceEventListener;
    private Map<Integer, ChannelMetadata> mChannelMetadataMap = new TreeMap<Integer, ChannelMetadata>();
    private Map<Integer, MutableIdentifierCollection> mIdentifierCollectionMap = new TreeMap<Integer, MutableIdentifierCollection>();
    private Map<Integer, StateMachine> mStateMachineMap = new TreeMap<Integer, StateMachine>();
    private Map<Integer, StateMonitoringSquelchController> mSquelchControllerMap = new TreeMap<Integer, StateMonitoringSquelchController>();
    private int[] mTimeslots;
    private DecoderStateNotificationEventCache mStateNotificationCache = new DecoderStateNotificationEventCache();
    private Listener<IdentifierUpdateNotification> mIdentifierUpdateListener = new IdentifierUpdateListenerProxy();

    public MultiChannelState(Channel channel, AliasModel aliasModel, int[] timeslots) {
        super(channel);
        this.mTimeslots = timeslots;
        for (int timeslot : timeslots) {
            this.mChannelMetadataMap.put(timeslot, new ChannelMetadata(aliasModel, timeslot));
            MutableIdentifierCollection mutableIdentifierCollection = new MutableIdentifierCollection(timeslot);
            this.mIdentifierCollectionMap.put(timeslot, mutableIdentifierCollection);
            mutableIdentifierCollection.setIdentifierUpdateListener(this.mIdentifierUpdateNotificationProxy);
            StateMachine stateMachine = new StateMachine(timeslot, State.MULTI_CHANNEL_ACTIVE_STATES);
            this.mStateMachineMap.put(timeslot, stateMachine);
            stateMachine.addListener(this);
            StateMonitoringSquelchController squelchController = new StateMonitoringSquelchController(timeslot);
            this.mSquelchControllerMap.put(timeslot, squelchController);
            stateMachine.addListener(squelchController);
            stateMachine.setIdentifierUpdateListener(mutableIdentifierCollection);
            stateMachine.setEndTimeoutBufferMilliseconds(2000L);
            stateMachine.setFadeTimeoutBufferMilliseconds(1200L);
        }
        this.configureChannelType(channel);
        this.createConfigurationIdentifiers(channel);
    }

    private void configureChannelType(Channel channel) {
        for (int timeslot : this.mTimeslots) {
            StateMachine stateMachine = this.mStateMachineMap.get(timeslot);
            stateMachine.setChannelType(channel.getChannelType());
        }
    }

    @Subscribe
    public void channelConfigurationChanged(ChannelConfigurationChangeNotification notification) {
        this.updateChannelConfiguration(notification.getChannel());
        this.configureChannelType(notification.getChannel());
        this.createConfigurationIdentifiers(notification.getChannel());
    }

    @Override
    public void stateChanged(State state, int timeslot) {
        ChannelStateIdentifier stateIdentifier = ChannelStateIdentifier.get(state);
        this.mIdentifierCollectionMap.get(timeslot).update(stateIdentifier);
        this.mChannelMetadataMap.get(timeslot).receive(new IdentifierUpdateNotification(stateIdentifier, IdentifierUpdateNotification.Operation.ADD, timeslot));
        switch (state) {
            case RESET: {
                this.reset(timeslot);
                this.mStateMachineMap.get(timeslot).setState(State.IDLE);
                break;
            }
            case TEARDOWN: {
                if (this.getChannel().isTrafficChannel()) {
                    this.checkTeardown();
                    break;
                }
                this.mStateMachineMap.get(timeslot).setState(State.RESET);
            }
        }
    }

    private void checkTeardown() {
        block7: {
            boolean active;
            boolean teardown;
            block6: {
                teardown = false;
                active = false;
                for (StateMachine stateMachine : this.mStateMachineMap.values()) {
                    State state = stateMachine.getState();
                    if (State.MULTI_CHANNEL_ACTIVE_STATES.contains((Object)state) && state != State.IDLE) {
                        active = true;
                        continue;
                    }
                    if (state != State.TEARDOWN) continue;
                    teardown = true;
                }
                if (!teardown || active) break block6;
                if (this.getChannel().isTrafficChannel()) {
                    this.broadcast(new ChannelEvent(this.getChannel(), ChannelEvent.Event.REQUEST_DISABLE));
                } else {
                    for (StateMachine stateMachine : this.mStateMachineMap.values()) {
                        stateMachine.setState(State.RESET);
                    }
                }
                break block7;
            }
            if (!teardown || !active) break block7;
            for (StateMachine stateMachine : this.mStateMachineMap.values()) {
                if (stateMachine.getState() != State.TEARDOWN) continue;
                stateMachine.setState(State.RESET);
            }
        }
    }

    @Override
    protected void checkState() {
        for (StateMachine stateMachine : this.mStateMachineMap.values()) {
            stateMachine.checkState();
        }
    }

    private void createConfigurationIdentifiers(Channel channel) {
        for (int timeslot : this.mTimeslots) {
            List<Long> frequencies;
            MutableIdentifierCollection identifierCollection = this.mIdentifierCollectionMap.get(timeslot);
            identifierCollection.update(DecoderTypeConfigurationIdentifier.create(channel.getDecodeConfiguration().getDecoderType()));
            if (channel.hasSystem()) {
                identifierCollection.update(SystemConfigurationIdentifier.create(channel.getSystem()));
            }
            if (channel.hasSite()) {
                identifierCollection.update(SiteConfigurationIdentifier.create(channel.getSite()));
            }
            if (channel.getName() != null && !channel.getName().isEmpty()) {
                identifierCollection.update(ChannelNameConfigurationIdentifier.create(channel.getName()));
            }
            if (channel.getAliasListName() != null && !channel.getAliasListName().isEmpty()) {
                identifierCollection.update(AliasListConfigurationIdentifier.create(channel.getAliasListName()));
            }
            if (channel.getSourceConfiguration().getSourceType() == SourceType.TUNER) {
                long frequency = ((SourceConfigTuner)channel.getSourceConfiguration()).getFrequency();
                identifierCollection.update(FrequencyConfigurationIdentifier.create(frequency));
                continue;
            }
            if (channel.getSourceConfiguration().getSourceType() != SourceType.TUNER_MULTIPLE_FREQUENCIES || (frequencies = ((SourceConfigTunerMultipleFrequency)channel.getSourceConfiguration()).getFrequencies()).size() <= 0) continue;
            identifierCollection.update(FrequencyConfigurationIdentifier.create(frequencies.get(0)));
        }
    }

    @Override
    public Listener<IdentifierUpdateNotification> getIdentifierUpdateListener() {
        return this.mIdentifierUpdateListener;
    }

    @Override
    public void setIdentifierUpdateListener(Listener<IdentifierUpdateNotification> listener) {
        this.mIdentifierUpdateNotificationProxy.setListener(listener);
    }

    @Override
    public void removeIdentifierUpdateListener() {
        this.mIdentifierUpdateNotificationProxy.setListener(null);
    }

    @Override
    public void updateChannelStateIdentifiers(IdentifierUpdateNotification notification) {
        MutableIdentifierCollection identifierCollection = this.mIdentifierCollectionMap.get(notification.getTimeslot());
        if (identifierCollection != null) {
            if (notification.isAdd()) {
                identifierCollection.update(notification.getIdentifier());
            } else if (notification.isSilentAdd()) {
                identifierCollection.silentUpdate(notification.getIdentifier());
            } else if (notification.isRemove()) {
                identifierCollection.remove(notification.getIdentifier());
            } else if (notification.isSilentRemove()) {
                identifierCollection.silentRemove(notification.getIdentifier());
            }
        }
    }

    @Override
    public List<ChannelMetadata> getChannelMetadata() {
        return new ArrayList<ChannelMetadata>(this.mChannelMetadataMap.values());
    }

    @Override
    public void reset() {
        for (int timeslot : this.mTimeslots) {
            this.reset(timeslot);
        }
        this.sourceOverflow(false);
    }

    private void reset(int timeslot) {
        this.mStateMachineMap.get(timeslot).setState(State.RESET);
        this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.REQUEST_RESET, State.IDLE, timeslot));
        MutableIdentifierCollection identifierCollection = this.mIdentifierCollectionMap.get(timeslot);
        identifierCollection.remove(IdentifierClass.USER);
    }

    @Override
    public void start() {
        for (int timeslot : this.mTimeslots) {
            this.mIdentifierCollectionMap.get(timeslot).broadcastIdentifiers();
            this.mStateMachineMap.get(timeslot).setState(State.RESET);
        }
    }

    @Override
    public void stop() {
        for (StateMonitoringSquelchController squelchController : this.mSquelchControllerMap.values()) {
            squelchController.setSquelchLock(false);
        }
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        if (this.mInternalSourceEventListener == null) {
            this.mInternalSourceEventListener = new SourceEventListener();
        }
        return this.mInternalSourceEventListener;
    }

    @Override
    public void setSquelchStateListener(Listener<SquelchStateEvent> listener) {
        for (StateMonitoringSquelchController squelchController : this.mSquelchControllerMap.values()) {
            squelchController.setSquelchStateListener(listener);
        }
    }

    @Override
    public void removeSquelchStateListener() {
        for (StateMonitoringSquelchController squelchController : this.mSquelchControllerMap.values()) {
            squelchController.removeSquelchStateListener();
        }
    }

    protected void broadcast(SourceEvent sourceEvent) {
        if (this.mExternalSourceEventListener != null) {
            this.mExternalSourceEventListener.receive(sourceEvent);
        }
    }

    protected void broadcast(IDecodeEvent event) {
        if (this.mDecodeEventListener != null) {
            this.mDecodeEventListener.receive(event);
        }
    }

    private void broadcast(ChannelEvent channelEvent) {
        if (this.mChannelEventListener != null) {
            this.mChannelEventListener.receive(channelEvent);
        }
    }

    protected void broadcast(DecoderStateEvent event) {
        if (this.mDecoderStateListener != null) {
            this.mDecoderStateListener.receive(event);
        }
    }

    @Override
    public Listener<DecoderStateEvent> getDecoderStateListener() {
        return this.mDecoderStateEventReceiver;
    }

    public class IdentifierUpdateNotificationProxy
    implements Listener<IdentifierUpdateNotification> {
        private Listener<IdentifierUpdateNotification> mIdentifierUpdateNotificationListener;

        public IdentifierUpdateNotificationProxy(MultiChannelState this$0) {
        }

        @Override
        public void receive(IdentifierUpdateNotification identifierUpdateNotification) {
            if (this.mIdentifierUpdateNotificationListener != null) {
                this.mIdentifierUpdateNotificationListener.receive(identifierUpdateNotification);
            }
        }

        public void setListener(Listener<IdentifierUpdateNotification> listener) {
            this.mIdentifierUpdateNotificationListener = listener;
        }

        public void removeListener() {
            this.mIdentifierUpdateNotificationListener = null;
        }
    }

    public class DecoderStateEventReceiver
    implements Listener<DecoderStateEvent> {
        @Override
        public void receive(DecoderStateEvent event) {
            if (event.getSource() != this) {
                switch (event.getEvent()) {
                    case REQUEST_ALWAYS_UNSQUELCH: {
                        MultiChannelState.this.mSquelchControllerMap.get(event.getTimeslot()).setSquelchLock(true);
                        break;
                    }
                    case REQUEST_CHANGE_CALL_TIMEOUT: {
                        if (!(event instanceof ChangeChannelTimeoutEvent)) break;
                        ChangeChannelTimeoutEvent timeout = (ChangeChannelTimeoutEvent)event;
                        MultiChannelState.this.mStateMachineMap.get(event.getTimeslot()).setFadeTimeoutBufferMilliseconds(timeout.getCallTimeoutMilliseconds());
                        break;
                    }
                    case CONTINUATION: 
                    case DECODE: 
                    case START: {
                        if (!State.MULTI_CHANNEL_ACTIVE_STATES.contains((Object)event.getState())) break;
                        MultiChannelState.this.mStateMachineMap.get(event.getTimeslot()).setState(event.getState());
                        MultiChannelState.this.broadcast(MultiChannelState.this.mStateNotificationCache.getStateNotificationEvent(event.getState(), event.getTimeslot()));
                        break;
                    }
                    case END: {
                        MultiChannelState.this.mStateMachineMap.get(event.getTimeslot()).setState(event.getState());
                        MultiChannelState.this.broadcast(MultiChannelState.this.mStateNotificationCache.getStateNotificationEvent(event.getState(), event.getTimeslot()));
                        break;
                    }
                    case REQUEST_RESET: {
                        break;
                    }
                }
            }
        }
    }

    public class IdentifierUpdateListenerProxy
    implements Listener<IdentifierUpdateNotification> {
        @Override
        public void receive(IdentifierUpdateNotification identifierUpdateNotification) {
            int timeslot = identifierUpdateNotification.getTimeslot();
            ChannelMetadata channelMetadata = MultiChannelState.this.mChannelMetadataMap.get(timeslot);
            if (channelMetadata != null) {
                channelMetadata.receive(identifierUpdateNotification);
            }
        }
    }

    public class SourceEventListener
    implements Listener<SourceEvent> {
        @Override
        public void receive(SourceEvent sourceEvent) {
            switch (sourceEvent.getEvent()) {
                case NOTIFICATION_FREQUENCY_CHANGE: {
                    long frequency = sourceEvent.getValue().longValue();
                    for (int timeslot : MultiChannelState.this.mTimeslots) {
                        MultiChannelState.this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.NOTIFICATION_SOURCE_FREQUENCY, MultiChannelState.this.mStateMachineMap.get(timeslot).getState(), frequency));
                        MultiChannelState.this.mIdentifierUpdateNotificationProxy.receive(new IdentifierUpdateNotification(FrequencyConfigurationIdentifier.create(frequency), IdentifierUpdateNotification.Operation.SILENT_ADD, timeslot));
                    }
                    break;
                }
                case NOTIFICATION_MEASURED_FREQUENCY_ERROR: {
                    for (int timeslot : MultiChannelState.this.mTimeslots) {
                        if (!State.MULTI_CHANNEL_ACTIVE_STATES.contains((Object)MultiChannelState.this.mStateMachineMap.get(timeslot).getState())) continue;
                        MultiChannelState.this.broadcast(SourceEvent.frequencyErrorMeasurementSyncLocked(sourceEvent.getValue().longValue(), MultiChannelState.this.getChannel().getChannelType().name()));
                        return;
                    }
                    break;
                }
            }
        }
    }
}

