/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.state;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.channel.state.AbstractDecoderState;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.identifier.configuration.ChannelDescriptorConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.DecoderTypeConfigurationIdentifier;
import io.github.dsheirer.sample.Listener;

public abstract class DecoderState
extends AbstractDecoderState {
    private MutableIdentifierCollection mIdentifierCollection;
    protected Listener<IdentifierUpdateNotification> mConfigurationIdentifierListener;
    protected IChannelDescriptor mCurrentChannel;

    public DecoderState(MutableIdentifierCollection mutableIdentifierCollection) {
        this.mIdentifierCollection = mutableIdentifierCollection;
        this.mIdentifierCollection.update(new DecoderTypeConfigurationIdentifier(this.getDecoderType()));
    }

    public DecoderState() {
        this(new MutableIdentifierCollection());
        this.mConfigurationIdentifierListener = new ConfigurationIdentifierListener();
    }

    @Override
    public void start() {
        this.mIdentifierCollection.broadcastIdentifiers();
    }

    @Override
    public void setIdentifierUpdateListener(Listener<IdentifierUpdateNotification> listener) {
        this.getIdentifierCollection().setIdentifierUpdateListener(listener);
    }

    @Override
    public void removeIdentifierUpdateListener() {
        this.getIdentifierCollection().removeIdentifierUpdateListener();
    }

    public MutableIdentifierCollection getIdentifierCollection() {
        return this.mIdentifierCollection;
    }

    protected IChannelDescriptor getCurrentChannel() {
        return this.mCurrentChannel;
    }

    protected void setCurrentChannel(IChannelDescriptor channel) {
        this.mCurrentChannel = channel;
    }

    protected void resetState() {
        this.mIdentifierCollection.remove(IdentifierClass.USER);
    }

    @Override
    public void reset() {
        this.setCurrentChannel(null);
    }

    public abstract void init();

    @Override
    public Listener<IdentifierUpdateNotification> getIdentifierUpdateListener() {
        return this.mConfigurationIdentifierListener;
    }

    public Listener<IdentifierUpdateNotification> getConfigurationIdentifierListener() {
        return this.mConfigurationIdentifierListener;
    }

    public class ConfigurationIdentifierListener
    implements Listener<IdentifierUpdateNotification> {
        @Override
        public void receive(IdentifierUpdateNotification identifierUpdateNotification) {
            DecoderState.this.getIdentifierCollection().receive(identifierUpdateNotification);
            if (identifierUpdateNotification.getIdentifier() instanceof ChannelDescriptorConfigurationIdentifier) {
                DecoderState.this.setCurrentChannel((IChannelDescriptor)((ChannelDescriptorConfigurationIdentifier)identifierUpdateNotification.getIdentifier()).getValue());
            }
        }
    }
}

