/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.metadata;

import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideTabbedPane;
import io.github.dsheirer.channel.details.ChannelDetailPanel;
import io.github.dsheirer.channel.metadata.ChannelMetadataPanel;
import io.github.dsheirer.gui.power.ChannelPowerPanel;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.module.decode.event.DecodeEventPanel;
import io.github.dsheirer.module.decode.event.MessageActivityPanel;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.settings.SettingsManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class NowPlayingPanel
extends JPanel {
    private final ChannelMetadataPanel mChannelMetadataPanel;
    private final ChannelDetailPanel mChannelDetailPanel;
    private final DecodeEventPanel mDecodeEventPanel;
    private final MessageActivityPanel mMessageActivityPanel;
    private final ChannelPowerPanel mChannelPowerPanel;
    private JideTabbedPane mTabbedPane;
    private JideSplitPane mSplitPane;
    private boolean mDetailTabsVisible;

    public NowPlayingPanel(PlaylistManager playlistManager, IconModel iconModel, UserPreferences userPreferences, SettingsManager settingsManager, boolean detailTabsVisible) {
        this.mChannelDetailPanel = new ChannelDetailPanel(playlistManager.getChannelProcessingManager());
        this.mDecodeEventPanel = new DecodeEventPanel(iconModel, userPreferences, playlistManager.getAliasModel());
        this.mMessageActivityPanel = new MessageActivityPanel(userPreferences);
        this.mChannelMetadataPanel = new ChannelMetadataPanel(playlistManager, iconModel, userPreferences);
        this.mChannelPowerPanel = new ChannelPowerPanel(playlistManager, settingsManager);
        this.mDetailTabsVisible = detailTabsVisible;
        this.init();
    }

    public void setDetailTabsVisible(boolean visible) {
        if (visible ^ this.mDetailTabsVisible) {
            this.mDetailTabsVisible = visible;
            if (this.mDetailTabsVisible) {
                this.getSplitPane().add((Component)this.getTabbedPane());
            } else {
                this.getSplitPane().remove((Component)this.getTabbedPane());
            }
            this.revalidate();
        }
    }

    private JideTabbedPane getTabbedPane() {
        if (this.mTabbedPane == null) {
            this.mTabbedPane = new JideTabbedPane();
            this.mTabbedPane.addTab("Details", (Component)this.mChannelDetailPanel);
            this.mTabbedPane.addTab("Events", (Component)this.mDecodeEventPanel);
            this.mTabbedPane.addTab("Messages", (Component)this.mMessageActivityPanel);
            this.mTabbedPane.addTab("Channel", (Component)this.mChannelPowerPanel);
            this.mTabbedPane.setFont(this.getFont());
            this.mTabbedPane.setForeground(Color.BLACK);
            this.mTabbedPane.addChangeListener(e -> this.mChannelPowerPanel.setPanelVisible(this.getTabbedPane().getSelectedIndex() == this.getTabbedPane().indexOfComponent((Component)this.mChannelPowerPanel)));
        }
        return this.mTabbedPane;
    }

    private JideSplitPane getSplitPane() {
        if (this.mSplitPane == null) {
            this.mSplitPane = new JideSplitPane(0);
            this.mSplitPane.setShowGripper(true);
        }
        return this.mSplitPane;
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[grow,fill]"));
        this.getSplitPane().add((Component)this.mChannelMetadataPanel);
        if (this.mDetailTabsVisible) {
            this.getSplitPane().add((Component)this.getTabbedPane());
        }
        this.add((Component)this.getSplitPane());
        this.mChannelMetadataPanel.addProcessingChainSelectionListener(this.mChannelDetailPanel);
        this.mChannelMetadataPanel.addProcessingChainSelectionListener(this.mDecodeEventPanel);
        this.mChannelMetadataPanel.addProcessingChainSelectionListener(this.mMessageActivityPanel);
        this.mChannelMetadataPanel.addProcessingChainSelectionListener(this.mChannelPowerPanel);
    }
}

