/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.metadata;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.channel.metadata.ChannelAndMetadata;
import io.github.dsheirer.channel.metadata.ChannelMetadata;
import io.github.dsheirer.channel.metadata.ChannelMetadataField;
import io.github.dsheirer.channel.metadata.IChannelMetadataUpdateListener;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.decoder.DecoderLogicalChannelNameIdentifier;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.sample.Listener;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelMetadataModel
extends AbstractTableModel
implements IChannelMetadataUpdateListener {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelMetadataModel.class);
    public static final int COLUMN_DECODER_STATE = 0;
    public static final int COLUMN_DECODER_TYPE = 1;
    public static final int COLUMN_USER_FROM = 2;
    public static final int COLUMN_USER_FROM_ALIAS = 3;
    public static final int COLUMN_USER_TO = 4;
    public static final int COLUMN_USER_TO_ALIAS = 5;
    public static final int COLUMN_DECODER_LOGICAL_CHANNEL_NAME = 6;
    public static final int COLUMN_CONFIGURATION_FREQUENCY = 7;
    public static final int COLUMN_CONFIGURATION_CHANNEL = 8;
    private static final String[] COLUMNS = new String[]{"Status", "Decoder", "From", "Alias", "To", "Alias", "Channel", "Frequency", "Channel Name"};
    private List<ChannelMetadata> mChannelMetadata = new ArrayList<ChannelMetadata>();
    private Map<ChannelMetadata, Channel> mMetadataChannelMap = new HashMap<ChannelMetadata, Channel>();
    private Listener<ChannelAndMetadata> mChannelAddListener;

    public ChannelMetadataModel() {
        MyEventBus.getGlobalEventBus().register((Object)this);
    }

    @Subscribe
    public void preferenceUpdated(PreferenceType preferenceType) {
        if (preferenceType == PreferenceType.TALKGROUP_FORMAT) {
            EventQueue.invokeLater(() -> {
                for (int row = 0; row < this.mChannelMetadata.size(); ++row) {
                    this.fireTableCellUpdated(row, 2);
                    this.fireTableCellUpdated(row, 4);
                }
            });
        }
    }

    public void dispose() {
        MyEventBus.getGlobalEventBus().unregister((Object)this);
    }

    public int getRow(ChannelMetadata channelMetadata) {
        if (this.mChannelMetadata.contains(channelMetadata)) {
            return this.mChannelMetadata.indexOf(channelMetadata);
        }
        return -1;
    }

    public void setChannelAddListener(Listener<ChannelAndMetadata> listener) {
        this.mChannelAddListener = listener;
    }

    public void add(ChannelAndMetadata channelAndMetadata) {
        EventQueue.invokeLater(() -> {
            for (ChannelMetadata channelMetadata : channelAndMetadata.getChannelMetadata()) {
                this.mChannelMetadata.add(channelMetadata);
                this.mMetadataChannelMap.put(channelMetadata, channelAndMetadata.getChannel());
                int index = this.mChannelMetadata.indexOf(channelMetadata);
                this.fireTableRowsInserted(index, index);
                channelMetadata.setUpdateEventListener(this);
            }
            if (this.mChannelAddListener != null) {
                this.mChannelAddListener.receive(channelAndMetadata);
            }
        });
    }

    public void updateChannelMetadataToChannelMap(Collection<ChannelMetadata> channelMetadatas, Channel channel) {
        for (ChannelMetadata channelMetadata : channelMetadatas) {
            this.mMetadataChannelMap.put(channelMetadata, channel);
        }
    }

    public void remove(ChannelMetadata channelMetadata) {
        EventQueue.invokeLater(() -> {
            channelMetadata.removeUpdateEventListener();
            int index = this.mChannelMetadata.indexOf(channelMetadata);
            this.mChannelMetadata.remove(channelMetadata);
            this.mMetadataChannelMap.remove(channelMetadata);
            if (index >= 0) {
                this.fireTableRowsDeleted(index, index);
            }
        });
    }

    public ChannelMetadata getChannelMetadata(int row) {
        if (row < this.mChannelMetadata.size()) {
            return this.mChannelMetadata.get(row);
        }
        return null;
    }

    public Channel getChannelFromMetadata(ChannelMetadata channelMetadata) {
        return this.mMetadataChannelMap.get(channelMetadata);
    }

    @Override
    public int getRowCount() {
        return this.mChannelMetadata.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMNS[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 2: 
            case 4: {
                return ChannelMetadata.class;
            }
            case 3: 
            case 5: {
                return Alias.class;
            }
            case 6: {
                return String.class;
            }
        }
        return Identifier.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex <= this.mChannelMetadata.size()) {
            ChannelMetadata channelMetadata = this.mChannelMetadata.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return channelMetadata.getChannelStateIdentifier();
                }
                case 1: {
                    return channelMetadata.getDecoderTypeConfigurationIdentifier();
                }
                case 6: {
                    DecoderLogicalChannelNameIdentifier id = channelMetadata.getDecoderLogicalChannelNameIdentifier();
                    if (channelMetadata.hasTimeslot()) {
                        if (id == null) {
                            return "TS:" + channelMetadata.getTimeslot();
                        }
                        String value = ((String)id.getValue()).replace(" TS0", "").replace(" TS1", "");
                        return value + " TS:" + channelMetadata.getTimeslot();
                    }
                    if (id == null) {
                        return null;
                    }
                    return id.getValue();
                }
                case 7: {
                    return channelMetadata.getFrequencyConfigurationIdentifier();
                }
                case 8: {
                    return channelMetadata.getChannelNameConfigurationIdentifier();
                }
                case 4: {
                    return channelMetadata;
                }
                case 2: {
                    return channelMetadata;
                }
                case 3: {
                    return channelMetadata.getFromIdentifierAliases();
                }
                case 5: {
                    return channelMetadata.getToIdentifierAliases();
                }
            }
        }
        return null;
    }

    @Override
    public void updated(ChannelMetadata channelMetadata, final ChannelMetadataField channelMetadataField) {
        final int rowIndex = this.mChannelMetadata.indexOf(channelMetadata);
        if (rowIndex >= 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (channelMetadataField) {
                        case CONFIGURATION_CHANNEL: {
                            ChannelMetadataModel.this.fireTableCellUpdated(rowIndex, 8);
                            break;
                        }
                        case CONFIGURATION_FREQUENCY: {
                            ChannelMetadataModel.this.fireTableCellUpdated(rowIndex, 7);
                            break;
                        }
                        case DECODER_CHANNEL_NAME: {
                            ChannelMetadataModel.this.fireTableCellUpdated(rowIndex, 6);
                            break;
                        }
                        case DECODER_TYPE: {
                            ChannelMetadataModel.this.fireTableCellUpdated(rowIndex, 1);
                            break;
                        }
                        case DECODER_STATE: {
                            ChannelMetadataModel.this.fireTableCellUpdated(rowIndex, 0);
                            break;
                        }
                        case USER_FROM: {
                            ChannelMetadataModel.this.fireTableCellUpdated(rowIndex, 2);
                            ChannelMetadataModel.this.fireTableCellUpdated(rowIndex, 3);
                            break;
                        }
                        case USER_TO: {
                            ChannelMetadataModel.this.fireTableCellUpdated(rowIndex, 4);
                            ChannelMetadataModel.this.fireTableCellUpdated(rowIndex, 5);
                        }
                    }
                }
            });
        }
    }
}

