/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.metadata;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.channel.metadata.ChannelMetadataField;
import io.github.dsheirer.channel.metadata.IChannelMetadataUpdateListener;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierUpdateListener;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.configuration.AliasListConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.ChannelNameConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.DecoderTypeConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.FrequencyConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.SiteConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.SystemConfigurationIdentifier;
import io.github.dsheirer.identifier.decoder.ChannelStateIdentifier;
import io.github.dsheirer.identifier.decoder.DecoderLogicalChannelNameIdentifier;
import io.github.dsheirer.sample.Listener;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelMetadata
implements Listener<IdentifierUpdateNotification>,
IdentifierUpdateListener {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelMetadata.class);
    private SystemConfigurationIdentifier mSystemConfigurationIdentifier;
    private SiteConfigurationIdentifier mSiteConfigurationIdentifier;
    private ChannelNameConfigurationIdentifier mChannelNameConfigurationIdentifier;
    private FrequencyConfigurationIdentifier mFrequencyConfigurationIdentifier;
    private ChannelStateIdentifier mChannelStateIdentifier = ChannelStateIdentifier.IDLE;
    private DecoderLogicalChannelNameIdentifier mDecoderLogicalChannelNameIdentifier;
    private DecoderTypeConfigurationIdentifier mDecoderTypeConfigurationIdentifier;
    private Identifier mFromIdentifier;
    private List<Alias> mFromIdentifierAliases;
    private Identifier mToIdentifier;
    private List<Alias> mToIdentifierAliases;
    private Integer mTimeslot;
    private IChannelMetadataUpdateListener mIChannelMetadataUpdateListener;
    private AliasModel mAliasModel;
    private AliasList mAliasList;

    public ChannelMetadata(AliasModel aliasModel, Integer timeslot) {
        this.mAliasModel = aliasModel;
        this.mTimeslot = timeslot;
    }

    public ChannelMetadata(AliasModel aliasModel) {
        this(aliasModel, null);
    }

    public Integer getTimeslot() {
        return this.mTimeslot;
    }

    public boolean hasTimeslot() {
        return this.mTimeslot != null;
    }

    @Override
    public Listener<IdentifierUpdateNotification> getIdentifierUpdateListener() {
        return this;
    }

    public SystemConfigurationIdentifier getSystemConfigurationIdentifier() {
        return this.mSystemConfigurationIdentifier;
    }

    public boolean hasSystemConfigurationIdentifier() {
        return this.mSystemConfigurationIdentifier != null;
    }

    public SiteConfigurationIdentifier getSiteConfigurationIdentifier() {
        return this.mSiteConfigurationIdentifier;
    }

    public boolean hasSiteConfigurationIdentifier() {
        return this.mSiteConfigurationIdentifier != null;
    }

    public ChannelNameConfigurationIdentifier getChannelNameConfigurationIdentifier() {
        return this.mChannelNameConfigurationIdentifier;
    }

    public boolean hasChannelConfigurationIdentifier() {
        return this.mChannelNameConfigurationIdentifier != null;
    }

    public DecoderLogicalChannelNameIdentifier getDecoderLogicalChannelNameIdentifier() {
        return this.mDecoderLogicalChannelNameIdentifier;
    }

    public boolean hasDecoderLogicalChannelNameIdentifier() {
        return this.mDecoderLogicalChannelNameIdentifier != null;
    }

    public FrequencyConfigurationIdentifier getFrequencyConfigurationIdentifier() {
        return this.mFrequencyConfigurationIdentifier;
    }

    public boolean hasFrequencyConfigurationIdentifier() {
        return this.mFrequencyConfigurationIdentifier != null;
    }

    public ChannelStateIdentifier getChannelStateIdentifier() {
        return this.mChannelStateIdentifier;
    }

    public boolean hasDecoderStateIdentifier() {
        return this.mChannelStateIdentifier != null;
    }

    public DecoderTypeConfigurationIdentifier getDecoderTypeConfigurationIdentifier() {
        return this.mDecoderTypeConfigurationIdentifier;
    }

    public boolean hasDecoderTypeIdentifier() {
        return this.mDecoderTypeConfigurationIdentifier != null;
    }

    public Identifier getFromIdentifier() {
        return this.mFromIdentifier;
    }

    public boolean hasFromIdentifier() {
        return this.mFromIdentifier != null;
    }

    public List<Alias> getFromIdentifierAliases() {
        return this.mFromIdentifierAliases;
    }

    public Identifier getToIdentifier() {
        return this.mToIdentifier;
    }

    public boolean hasToIdentifier() {
        return this.mToIdentifier != null;
    }

    public List<Alias> getToIdentifierAliases() {
        return this.mToIdentifierAliases;
    }

    public void setUpdateEventListener(IChannelMetadataUpdateListener listener) {
        this.mIChannelMetadataUpdateListener = listener;
    }

    public void removeUpdateEventListener() {
        this.mIChannelMetadataUpdateListener = null;
    }

    private void broadcastUpdate(ChannelMetadataField field) {
        if (this.mIChannelMetadataUpdateListener != null) {
            this.mIChannelMetadataUpdateListener.updated(this, field);
        }
    }

    @Override
    public void receive(IdentifierUpdateNotification update) {
        Identifier<?> identifier = update.getIdentifier();
        switch (identifier.getIdentifierClass()) {
            case CONFIGURATION: {
                switch (identifier.getForm()) {
                    case ALIAS_LIST: {
                        if (!update.isAdd()) break;
                        this.mAliasList = this.mAliasModel.getAliasList((AliasListConfigurationIdentifier)identifier);
                        if (this.mAliasList == null) break;
                        if (this.mToIdentifier != null) {
                            this.mToIdentifierAliases = this.mAliasList.getAliases(this.mToIdentifier);
                        }
                        if (this.mFromIdentifier == null) break;
                        this.mFromIdentifierAliases = this.mAliasList.getAliases(this.mFromIdentifier);
                        break;
                    }
                    case CHANNEL: {
                        this.mChannelNameConfigurationIdentifier = identifier instanceof ChannelNameConfigurationIdentifier && (update.isAdd() || update.isSilentAdd()) ? (ChannelNameConfigurationIdentifier)identifier : null;
                        this.broadcastUpdate(ChannelMetadataField.CONFIGURATION_CHANNEL);
                        break;
                    }
                    case CHANNEL_FREQUENCY: {
                        this.mFrequencyConfigurationIdentifier = identifier instanceof FrequencyConfigurationIdentifier && (update.isAdd() || update.isSilentAdd()) ? (FrequencyConfigurationIdentifier)identifier : null;
                        this.broadcastUpdate(ChannelMetadataField.CONFIGURATION_FREQUENCY);
                        break;
                    }
                    case DECODER_TYPE: {
                        this.mDecoderTypeConfigurationIdentifier = identifier instanceof DecoderTypeConfigurationIdentifier && (update.isAdd() || update.isSilentAdd()) ? (DecoderTypeConfigurationIdentifier)identifier : null;
                        this.broadcastUpdate(ChannelMetadataField.DECODER_TYPE);
                        break;
                    }
                    case SITE: {
                        this.mSiteConfigurationIdentifier = identifier instanceof SiteConfigurationIdentifier && (update.isAdd() || update.isSilentAdd()) ? (SiteConfigurationIdentifier)identifier : null;
                        this.broadcastUpdate(ChannelMetadataField.CONFIGURATION_SITE);
                        break;
                    }
                    case SYSTEM: {
                        this.mSystemConfigurationIdentifier = identifier instanceof SystemConfigurationIdentifier && (update.isAdd() || update.isSilentAdd()) ? (SystemConfigurationIdentifier)identifier : null;
                        this.broadcastUpdate(ChannelMetadataField.CONFIGURATION_SYSTEM);
                    }
                }
                break;
            }
            case DECODER: {
                switch (identifier.getForm()) {
                    case CHANNEL_NAME: {
                        this.mDecoderLogicalChannelNameIdentifier = identifier instanceof DecoderLogicalChannelNameIdentifier && (update.isAdd() || update.isSilentAdd()) ? (DecoderLogicalChannelNameIdentifier)identifier : null;
                        this.broadcastUpdate(ChannelMetadataField.DECODER_CHANNEL_NAME);
                        break;
                    }
                    case STATE: {
                        this.mChannelStateIdentifier = identifier instanceof ChannelStateIdentifier && (update.isAdd() || update.isSilentAdd()) ? (ChannelStateIdentifier)identifier : null;
                        this.broadcastUpdate(ChannelMetadataField.DECODER_STATE);
                    }
                }
                break;
            }
            case USER: {
                if (identifier.getRole() == Role.FROM) {
                    this.mFromIdentifier = update.isAdd() ? identifier : null;
                    this.mFromIdentifierAliases = this.mAliasList != null && this.mFromIdentifier != null ? this.mAliasList.getAliases(this.mFromIdentifier) : Collections.EMPTY_LIST;
                    this.broadcastUpdate(ChannelMetadataField.USER_FROM);
                    break;
                }
                if (identifier.getRole() != Role.TO) break;
                this.mToIdentifier = update.isAdd() ? identifier : null;
                this.mToIdentifierAliases = this.mAliasList != null && this.mToIdentifier != null ? this.mAliasList.getAliases(this.mToIdentifier) : Collections.EMPTY_LIST;
                this.broadcastUpdate(ChannelMetadataField.USER_TO);
            }
        }
    }
}

