/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.details;

import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelProcessingManager;
import io.github.dsheirer.module.ProcessingChain;
import io.github.dsheirer.sample.Listener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;
import net.miginfocom.swing.MigLayout;

public class ChannelDetailPanel
extends JPanel
implements Listener<ProcessingChain> {
    private static final String EMPTY_DETAILS = "Please select a channel to view details";
    private JLabel mSystemLabel;
    private JLabel mSiteLabel;
    private JLabel mNameLabel;
    private JTextArea mDetailTextPane;
    private ChannelProcessingManager mChannelProcessingManager;
    private ProcessingChain mProcessingChain;

    public ChannelDetailPanel(ChannelProcessingManager channelProcessingManager) {
        this.mChannelProcessingManager = channelProcessingManager;
        this.init();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[]0[grow,fill]"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout((LayoutManager)new MigLayout("insets 1 1 1 1", "[][grow,fill][][grow,fill][][grow,fill][]", ""));
        buttonPanel.add(new JLabel("System:"));
        this.mSystemLabel = new JLabel(" ");
        buttonPanel.add(this.mSystemLabel);
        buttonPanel.add(new JLabel("Site:"));
        this.mSiteLabel = new JLabel(" ");
        buttonPanel.add(this.mSiteLabel);
        buttonPanel.add(new JLabel("Channel Name:"));
        this.mNameLabel = new JLabel(" ");
        buttonPanel.add(this.mNameLabel);
        JButton refreshButton = new JButton("Refresh");
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChannelDetailPanel.this.receive(ChannelDetailPanel.this.mProcessingChain);
            }
        });
        buttonPanel.add(refreshButton);
        this.add((Component)buttonPanel, "wrap");
        this.mDetailTextPane = new JTextArea(EMPTY_DETAILS);
        DefaultCaret caret = (DefaultCaret)this.mDetailTextPane.getCaret();
        caret.setUpdatePolicy(1);
        this.add(new JScrollPane(this.mDetailTextPane));
    }

    @Override
    public void receive(ProcessingChain processingChain) {
        String details;
        String name;
        String site;
        this.mProcessingChain = processingChain;
        Channel channel = this.mChannelProcessingManager.getChannel(processingChain);
        final String system = channel != null ? channel.getSystem() : null;
        String string = site = channel != null ? channel.getSite() : null;
        String string2 = channel != null ? (channel.getChannelType() == Channel.ChannelType.TRAFFIC ? "Traffic Channel" : channel.getName()) : (name = null);
        if (processingChain != null) {
            StringBuilder sb = new StringBuilder();
            for (DecoderState decoderState : processingChain.getDecoderStates()) {
                sb.append(decoderState.getActivitySummary());
            }
            details = sb.toString();
        } else {
            details = EMPTY_DETAILS;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChannelDetailPanel.this.mSystemLabel.setText(system);
                ChannelDetailPanel.this.mSiteLabel.setText(site);
                ChannelDetailPanel.this.mNameLabel.setText(name);
                ChannelDetailPanel.this.mDetailTextPane.setText(details);
            }
        });
    }
}

