/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer.airspy.hf;

import io.github.dsheirer.buffer.AbstractNativeBuffer;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import java.util.Iterator;

public class AirspyHfNativeBuffer
extends AbstractNativeBuffer {
    public static final float SCALE = 3.0517578E-5f;
    private short[] mInterleavedSamples;
    private float mAverageDc;

    public AirspyHfNativeBuffer(long timestamp, float samplesPerMillisecond, float averageDc, short[] interleavedSamples) {
        super(timestamp, samplesPerMillisecond);
        this.mInterleavedSamples = interleavedSamples;
        this.mAverageDc = averageDc;
    }

    @Override
    public Iterator<ComplexSamples> iterator() {
        return new IteratorComplexSamples();
    }

    @Override
    public Iterator<InterleavedComplexSamples> iteratorInterleaved() {
        return new IteratorInterleaved();
    }

    @Override
    public int sampleCount() {
        return this.mInterleavedSamples.length / 2;
    }

    public class IteratorComplexSamples
    implements Iterator<ComplexSamples> {
        private boolean mHasNext = true;

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public ComplexSamples next() {
            int length = AirspyHfNativeBuffer.this.mInterleavedSamples.length / 2;
            float[] i = new float[length];
            float[] q = new float[length];
            int index = 0;
            for (int x = 0; x < AirspyHfNativeBuffer.this.mInterleavedSamples.length; x += 2) {
                index = x / 2;
                i[index] = (float)AirspyHfNativeBuffer.this.mInterleavedSamples[x + 1] * 3.0517578E-5f - AirspyHfNativeBuffer.this.mAverageDc;
                q[index] = (float)AirspyHfNativeBuffer.this.mInterleavedSamples[x] * 3.0517578E-5f - AirspyHfNativeBuffer.this.mAverageDc;
            }
            this.mHasNext = false;
            return new ComplexSamples(i, q, AirspyHfNativeBuffer.this.getTimestamp());
        }
    }

    public class IteratorInterleaved
    implements Iterator<InterleavedComplexSamples> {
        private boolean mHasNext = true;

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public InterleavedComplexSamples next() {
            float[] samples = new float[AirspyHfNativeBuffer.this.mInterleavedSamples.length];
            for (int x = 0; x < AirspyHfNativeBuffer.this.mInterleavedSamples.length; x += 2) {
                samples[x] = (float)AirspyHfNativeBuffer.this.mInterleavedSamples[x + 1] * 3.0517578E-5f - AirspyHfNativeBuffer.this.mAverageDc;
                samples[x + 1] = (float)AirspyHfNativeBuffer.this.mInterleavedSamples[x] * 3.0517578E-5f - AirspyHfNativeBuffer.this.mAverageDc;
            }
            this.mHasNext = false;
            return new InterleavedComplexSamples(samples, AirspyHfNativeBuffer.this.getTimestamp());
        }
    }
}

