/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer.airspy;

import io.github.dsheirer.buffer.DcCorrectionManager;
import io.github.dsheirer.buffer.airspy.IAirspySampleConverter;
import java.nio.ByteBuffer;
import jdk.incubator.vector.ShortVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class VectorUnpackedSampleConverter
implements IAirspySampleConverter {
    private static final VectorSpecies<Short> VECTOR_SPECIES = ShortVector.SPECIES_PREFERRED;
    private DcCorrectionManager mDcCalculationManager = new DcCorrectionManager();

    @Override
    public short[] convert(ByteBuffer buffer) {
        boolean shouldCalculateDc = this.mDcCalculationManager.shouldCalculateDc();
        short[] samples = new short[buffer.capacity() / 2];
        int rawPointer = 0;
        short[] bytes1 = new short[VECTOR_SPECIES.length()];
        short[] bytes2 = new short[VECTOR_SPECIES.length()];
        if (shouldCalculateDc) {
            long dcAccumulator = 0L;
            for (samplesOffset = 0; samplesOffset < VECTOR_SPECIES.loopBound(samples.length); samplesOffset += VECTOR_SPECIES.length()) {
                int bytesOffset = 0;
                while (bytesOffset < VECTOR_SPECIES.length()) {
                    bytes1[bytesOffset] = (short)(buffer.get(rawPointer++) & 0xFF);
                    bytes2[bytesOffset++] = (short)(buffer.get(rawPointer++) & 0xF);
                }
                ShortVector vector = ShortVector.fromArray(VECTOR_SPECIES, (short[])bytes1, (int)0).or((Vector)ShortVector.fromArray(VECTOR_SPECIES, (short[])bytes2, (int)0).lanewise(VectorOperators.LSHL, 8L));
                dcAccumulator += (long)vector.reduceLanes(VectorOperators.ADD);
                vector.intoArray(samples, samplesOffset);
            }
            while (samplesOffset < samples.length) {
                short sample;
                byte b1 = buffer.get(rawPointer++);
                byte b2 = buffer.get(rawPointer++);
                samples[samplesOffset] = sample = (short)((b2 & 0xF) << 8 | b1 & 0xFF);
                dcAccumulator += (long)sample;
                ++samplesOffset;
            }
            float averageDcNow = (float)dcAccumulator / (float)samples.length - 2048.0f;
            this.mDcCalculationManager.adjust(averageDcNow *= 4.8828125E-4f);
        } else {
            while (samplesOffset < VECTOR_SPECIES.loopBound(samples.length)) {
                int bytesOffset = 0;
                while (bytesOffset < VECTOR_SPECIES.length()) {
                    bytes1[bytesOffset] = (short)(buffer.get(rawPointer++) & 0xFF);
                    bytes2[bytesOffset++] = (short)(buffer.get(rawPointer++) & 0xF);
                }
                ShortVector vector = ShortVector.fromArray(VECTOR_SPECIES, (short[])bytes1, (int)0).or((Vector)ShortVector.fromArray(VECTOR_SPECIES, (short[])bytes2, (int)0).lanewise(VectorOperators.LSHL, 8L));
                vector.intoArray(samples, samplesOffset);
                samplesOffset += VECTOR_SPECIES.length();
            }
            while (samplesOffset < samples.length) {
                short sample;
                byte b1 = buffer.get(rawPointer++);
                byte b2 = buffer.get(rawPointer++);
                samples[samplesOffset] = sample = (short)((b2 & 0xF) << 8 | b1 & 0xFF);
                ++samplesOffset;
            }
        }
        return samples;
    }

    @Override
    public float getAverageDc() {
        return this.mDcCalculationManager.getAverageDc();
    }
}

