/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer.airspy;

import io.github.dsheirer.buffer.DcCorrectionManager;
import io.github.dsheirer.buffer.airspy.IAirspySampleConverter;
import io.github.dsheirer.buffer.airspy.VectorUnpackedSampleConverter;
import java.nio.ByteBuffer;

public class ScalarPackedSampleConverter
implements IAirspySampleConverter {
    private DcCorrectionManager mDcCalculationManager = new DcCorrectionManager();

    @Override
    public short[] convert(ByteBuffer buffer) {
        boolean shouldCalculateDc = this.mDcCalculationManager.shouldCalculateDc();
        int offset = 0;
        short[] samples = new short[buffer.capacity() / 3 * 2];
        if (shouldCalculateDc) {
            long dcAccumulator = 0L;
            for (int x = 0; x < samples.length; x += 2) {
                short sample;
                byte b1 = buffer.get(offset++);
                byte b2 = buffer.get(offset++);
                byte b3 = buffer.get(offset++);
                samples[x] = sample = (short)((b1 & 0xFF) << 4 | (b2 & 0xF0) >> 4);
                dcAccumulator += (long)sample;
                samples[x] = sample = (short)((b2 & 0xF) << 8 | b3 & 0xFF);
                dcAccumulator += (long)sample;
            }
            float averageDcNow = (float)dcAccumulator / (float)samples.length - 2048.0f;
            this.mDcCalculationManager.adjust(averageDcNow *= 4.8828125E-4f);
        } else {
            for (int x = 0; x < samples.length; x += 2) {
                short sample;
                byte b1 = buffer.get(offset++);
                byte b2 = buffer.get(offset++);
                byte b3 = buffer.get(offset++);
                samples[x] = sample = (short)((b1 & 0xFF) << 4 | (b2 & 0xF0) >> 4);
                samples[x] = sample = (short)((b2 & 0xF) << 8 | b3 & 0xFF);
            }
        }
        return samples;
    }

    @Override
    public float getAverageDc() {
        return this.mDcCalculationManager.getAverageDc();
    }

    public static void main(String[] args) {
        byte[] raw = new byte[262144];
        ByteBuffer buffer = ByteBuffer.wrap(raw);
        ScalarPackedSampleConverter scalar = new ScalarPackedSampleConverter();
        VectorUnpackedSampleConverter vector = new VectorUnpackedSampleConverter();
        long accumulator = 0L;
        int iterations = 1000000;
        System.out.println("Starting ...");
        long start = System.currentTimeMillis();
        for (int count = 0; count < iterations; ++count) {
            short[] samples = vector.convert(buffer);
            accumulator += (long)samples[1];
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("Accumulator: " + accumulator);
        System.out.println("Elapsed: " + (float)elapsed / 1000.0f);
        System.out.println("Finished");
    }
}

