/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer.airspy;

import io.github.dsheirer.buffer.AbstractNativeBufferFactory;
import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.buffer.airspy.AirspyNativeBuffer;
import io.github.dsheirer.buffer.airspy.IAirspySampleConverter;
import io.github.dsheirer.buffer.airspy.ScalarPackedSampleConverter;
import io.github.dsheirer.buffer.airspy.ScalarUnpackedSampleConverter;
import io.github.dsheirer.buffer.airspy.VectorUnpackedSampleConverter;
import io.github.dsheirer.vector.calibrate.CalibrationManager;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class AirspyNativeBufferFactory
extends AbstractNativeBufferFactory {
    private boolean mSamplePacking = false;
    private short[] mResidualI = new short[11];
    private short[] mResidualQ = new short[23];
    private IAirspySampleConverter mConverter;
    private Implementation mInterleavedIteratorImplementation;
    private Implementation mNonInterleavedIteratorImplementation;

    public AirspyNativeBufferFactory() {
        this.updateConverter();
        this.mInterleavedIteratorImplementation = CalibrationManager.getInstance().getImplementation(CalibrationType.AIRSPY_UNPACKED_INTERLEAVED_ITERATOR);
        this.mNonInterleavedIteratorImplementation = CalibrationManager.getInstance().getImplementation(CalibrationType.AIRSPY_UNPACKED_ITERATOR);
    }

    public void setSamplePacking(boolean enabled) {
        this.mSamplePacking = enabled;
        this.updateConverter();
    }

    private void updateConverter() {
        if (this.mSamplePacking) {
            if (!(this.mConverter instanceof ScalarPackedSampleConverter)) {
                this.mConverter = new ScalarPackedSampleConverter();
            }
        } else {
            Implementation implementation = CalibrationManager.getInstance().getImplementation(CalibrationType.AIRSPY_SAMPLE_CONVERTER);
            if (implementation == Implementation.VECTOR_SIMD_PREFERRED) {
                if (!(this.mConverter instanceof VectorUnpackedSampleConverter)) {
                    this.mConverter = new VectorUnpackedSampleConverter();
                }
            } else if (!(this.mConverter instanceof ScalarUnpackedSampleConverter)) {
                this.mConverter = new ScalarUnpackedSampleConverter();
            }
        }
    }

    @Override
    public INativeBuffer getBuffer(ByteBuffer buffer, long timestamp) {
        short[] samples = this.mConverter.convert(buffer);
        AirspyNativeBuffer nativeBuffer = new AirspyNativeBuffer(samples, Arrays.copyOf(this.mResidualI, this.mResidualI.length), Arrays.copyOf(this.mResidualQ, this.mResidualQ.length), this.mConverter.getAverageDc(), timestamp, this.mInterleavedIteratorImplementation, this.mNonInterleavedIteratorImplementation, this.getSamplesPerMillisecond());
        this.extractResidual(samples);
        return nativeBuffer;
    }

    private void extractResidual(short[] samples) {
        int offset = samples.length - 22;
        for (int i = 0; i < 11; ++i) {
            this.mResidualI[i] = samples[offset + 2 * i];
        }
        offset = samples.length - 46 + 1;
        for (int q = 0; q < 23; ++q) {
            this.mResidualQ[q] = samples[offset + 2 * q];
        }
    }
}

