/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer.airspy;

import io.github.dsheirer.buffer.airspy.AirspyBufferIterator;
import io.github.dsheirer.sample.complex.ComplexSamples;
import java.util.Arrays;

public class AirspyBufferIteratorScalar
extends AirspyBufferIterator<ComplexSamples> {
    public AirspyBufferIteratorScalar(short[] samples, short[] residualI, short[] residualQ, float averageDc, long timestamp, float samplesPerMillisecond) {
        super(samples, residualI, residualQ, averageDc, timestamp, samplesPerMillisecond);
    }

    @Override
    public ComplexSamples next() {
        if (this.mSamplesPointer >= this.mSamples.length) {
            throw new IllegalStateException("End of buffer exceeded");
        }
        long timestamp = this.getFragmentTimestamp(this.mSamplesPointer);
        int offset = this.mSamplesPointer;
        for (int x = 0; x < 2048; ++x) {
            this.mIBuffer[x + 11] = AirspyBufferIteratorScalar.scale(this.mSamples[offset++], this.mAverageDc);
            this.mQBuffer[x + 23] = AirspyBufferIteratorScalar.scale(this.mSamples[offset++], this.mAverageDc);
        }
        this.mSamplesPointer = offset;
        float[] i = Arrays.copyOf(this.mIBuffer, 2048);
        float[] q = new float[2048];
        for (int x = 0; x < 2048; ++x) {
            float accumulator = 0.0f;
            for (int tap = 0; tap < COEFFICIENTS.length; ++tap) {
                accumulator += COEFFICIENTS[tap] * this.mQBuffer[x + tap];
            }
            if (x % 2 == 0) {
                q[x] = accumulator;
                continue;
            }
            i[x] = -i[x];
            q[x] = -accumulator;
        }
        System.arraycopy(this.mIBuffer, 2048, this.mIBuffer, 0, 11);
        System.arraycopy(this.mQBuffer, 2048, this.mQBuffer, 0, 23);
        return new ComplexSamples(i, q, timestamp);
    }
}

