/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer;

public class FloatAveragingBuffer {
    private float[] mBuffer;
    private float mAverage = 0.0f;
    private int mBufferSize;
    private int mBufferPointer;

    public FloatAveragingBuffer(int size) {
        this.mBufferSize = size;
        this.mBuffer = new float[size];
    }

    public float get(float newValue) {
        float oldValue = this.mBuffer[this.mBufferPointer];
        if (Float.isInfinite(newValue) || Float.isNaN(newValue)) {
            this.mAverage -= oldValue / (float)this.mBufferSize;
            this.mBuffer[this.mBufferPointer++] = 0.0f;
        } else {
            this.mAverage = this.mAverage - oldValue / (float)this.mBufferSize + newValue / (float)this.mBufferSize;
            this.mBuffer[this.mBufferPointer++] = newValue;
        }
        if (this.mBufferPointer >= this.mBufferSize) {
            this.mBufferPointer = 0;
        }
        return this.mAverage;
    }
}

