/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer;

import java.util.Arrays;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;

public class DoubleCircularBuffer {
    private StandardDeviation mStandardDeviation;
    private Variance mVariance;
    private Max mMax;
    private Mean mMean;
    private Min mMin;
    private double[] mBuffer;
    private int mBufferPointer = 0;

    public DoubleCircularBuffer(int size, double initialFillValue) {
        this.mBuffer = new double[size];
        Arrays.fill(this.mBuffer, initialFillValue);
    }

    public DoubleCircularBuffer(int size) {
        this(size, 0.0);
    }

    public double get(double newValue) {
        double oldestSample = this.mBuffer[this.mBufferPointer];
        this.mBuffer[this.mBufferPointer] = newValue;
        ++this.mBufferPointer;
        if (this.mBufferPointer >= this.mBuffer.length) {
            this.mBufferPointer = 0;
        }
        return oldestSample;
    }

    public double[] getAll() {
        int valuePointer = 0;
        double[] values = new double[this.mBuffer.length];
        int bufferPointer = this.mBufferPointer;
        while (valuePointer < values.length) {
            values[valuePointer++] = this.mBuffer[bufferPointer++];
            if (bufferPointer < this.mBuffer.length) continue;
            bufferPointer = 0;
        }
        return values;
    }

    public void put(double newValue) {
        this.mBuffer[this.mBufferPointer] = newValue;
        ++this.mBufferPointer;
        if (this.mBufferPointer >= this.mBuffer.length) {
            this.mBufferPointer = 0;
        }
    }

    public double max() {
        if (this.mMax == null) {
            this.mMax = new Max();
        }
        return this.mMax.evaluate(this.mBuffer, 0, this.mBuffer.length);
    }

    public double min() {
        if (this.mMin == null) {
            this.mMin = new Min();
        }
        return this.mMin.evaluate(this.mBuffer, 0, this.mBuffer.length);
    }

    public double standardDeviation() {
        if (this.mStandardDeviation == null) {
            this.mStandardDeviation = new StandardDeviation();
        }
        return this.mStandardDeviation.evaluate(this.mBuffer);
    }

    public double variance() {
        if (this.mVariance == null) {
            this.mVariance = new Variance();
        }
        return this.mVariance.evaluate(this.mBuffer);
    }

    public double mean() {
        if (this.mMean == null) {
            this.mMean = new Mean();
        }
        return this.mMean.evaluate(this.mBuffer, 0, this.mBuffer.length);
    }
}

