/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer;

import java.util.concurrent.TimeUnit;

public class DcCorrectionManager {
    private static final long DC_PROCESSING_INTERVAL = TimeUnit.SECONDS.toMillis(50L);
    private static final int DC_CALCULATIONS_PER_INTERVAL = 5;
    private static final float TARGET_DC_OFFSET_REMAINING = 1.0E-4f;
    private int mDcCalculationsRemaining = 5;
    private long mLastDcCalculationTimestamp = 0L;
    private static final float DC_FILTER_GAIN = 0.05f;
    private float mAverageDc = 0.0f;

    public float getAverageDc() {
        return this.mAverageDc;
    }

    public void adjust(float calculatedDc) {
        float residualOffsetToRemove = calculatedDc - this.mAverageDc;
        this.mAverageDc += residualOffsetToRemove * 0.05f;
        if (Math.abs(residualOffsetToRemove) < 1.0E-4f) {
            --this.mDcCalculationsRemaining;
        }
    }

    public boolean shouldCalculateDc() {
        if (System.currentTimeMillis() > this.mLastDcCalculationTimestamp + DC_PROCESSING_INTERVAL) {
            if (this.mDcCalculationsRemaining > 0) {
                return true;
            }
            this.mDcCalculationsRemaining = 5;
            this.mLastDcCalculationTimestamp = System.currentTimeMillis();
        }
        return false;
    }
}

