/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer;

import io.github.dsheirer.sample.Listener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CircularBuffer<T>
implements Listener<T> {
    private List<T> mElements;
    private Listener<T> mListener;
    private int mPointer;
    private int mSize;

    public CircularBuffer(int size) {
        this.mSize = size;
        this.mElements = new ArrayList<T>();
    }

    public T get(int index) {
        if (index < this.mElements.size()) {
            return this.mElements.get(index);
        }
        return null;
    }

    public int getSize() {
        return this.mSize;
    }

    public List<T> getElements() {
        return Collections.unmodifiableList(this.mElements);
    }

    @Override
    public void receive(T element) {
        Object previous = null;
        if (this.mElements.size() > this.mPointer) {
            previous = this.mElements.get(this.mPointer);
            this.mElements.set(this.mPointer, element);
        } else {
            this.mElements.add(element);
        }
        ++this.mPointer;
        if (this.mPointer >= this.mSize) {
            this.mPointer = 0;
        }
        if (previous != null && this.mListener != null) {
            this.mListener.receive(previous);
        }
    }

    public void setListener(Listener<T> listener) {
        this.mListener = listener;
    }
}

