/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer;

import io.github.dsheirer.buffer.AbstractNativeBufferFactory;
import io.github.dsheirer.buffer.ByteNativeBuffer;
import io.github.dsheirer.buffer.DcCorrectionManager;
import io.github.dsheirer.buffer.INativeBuffer;
import java.nio.ByteBuffer;

public class ByteNativeBufferFactory
extends AbstractNativeBufferFactory {
    private DcCorrectionManager mDcCorrectionManager = new DcCorrectionManager();

    @Override
    public INativeBuffer getBuffer(ByteBuffer samples, long timestamp) {
        byte[] copy = new byte[samples.capacity()];
        samples.get(copy);
        if (this.mDcCorrectionManager.shouldCalculateDc()) {
            this.calculateDc(copy);
        }
        return new ByteNativeBuffer(copy, timestamp, this.mDcCorrectionManager.getAverageDc(), this.getSamplesPerMillisecond());
    }

    private void calculateDc(byte[] samples) {
        float dcAccumulator = 0.0f;
        for (byte sample : samples) {
            dcAccumulator += (float)(sample & 0xFF);
        }
        dcAccumulator /= (float)samples.length;
        dcAccumulator -= 127.5f;
        this.mDcCorrectionManager.adjust(dcAccumulator /= 128.0f);
    }
}

