/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer;

import io.github.dsheirer.buffer.AbstractNativeBuffer;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import java.util.Iterator;

public class ByteNativeBuffer
extends AbstractNativeBuffer {
    private static final int FRAGMENT_SIZE = 2048;
    private static final float[] LOOKUP_VALUES = new float[256];
    private float mAverageDc;
    private byte[] mSamples;

    public ByteNativeBuffer(byte[] samples, long timestamp, float averageDc, float samplesPerMillisecond) {
        super(timestamp, samplesPerMillisecond);
        if (samples.length % 2048 != 0) {
            throw new IllegalArgumentException("Samples byte[] length [" + samples.length + "] must be an even multiple of 2048");
        }
        this.mSamples = samples;
        this.mAverageDc = averageDc;
    }

    @Override
    public int sampleCount() {
        return this.mSamples.length / 2;
    }

    @Override
    public Iterator<ComplexSamples> iterator() {
        return new ComplexSamplesIterator();
    }

    @Override
    public Iterator<InterleavedComplexSamples> iteratorInterleaved() {
        return new InterleavedComplexSamplesIterator();
    }

    static {
        for (int x = 0; x < 256; ++x) {
            ByteNativeBuffer.LOOKUP_VALUES[x] = ((float)x - 127.5f) / 128.0f;
        }
    }

    private class ComplexSamplesIterator
    implements Iterator<ComplexSamples> {
        private int mSamplesPointer = 0;

        private ComplexSamplesIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.mSamplesPointer < ByteNativeBuffer.this.mSamples.length;
        }

        @Override
        public ComplexSamples next() {
            long timestamp = ByteNativeBuffer.this.getFragmentTimestamp(this.mSamplesPointer);
            float[] i = new float[2048];
            float[] q = new float[2048];
            int samplesOffset = this.mSamplesPointer;
            for (int pointer = 0; pointer < i.length; ++pointer) {
                i[pointer] = LOOKUP_VALUES[0xFF & ByteNativeBuffer.this.mSamples[samplesOffset++]] - ByteNativeBuffer.this.mAverageDc;
                q[pointer] = LOOKUP_VALUES[0xFF & ByteNativeBuffer.this.mSamples[samplesOffset++]] - ByteNativeBuffer.this.mAverageDc;
            }
            this.mSamplesPointer = samplesOffset;
            return new ComplexSamples(i, q, timestamp);
        }
    }

    private class InterleavedComplexSamplesIterator
    implements Iterator<InterleavedComplexSamples> {
        private int mSamplesPointer = 0;

        private InterleavedComplexSamplesIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.mSamplesPointer < ByteNativeBuffer.this.mSamples.length;
        }

        @Override
        public InterleavedComplexSamples next() {
            long timestamp = ByteNativeBuffer.this.getFragmentTimestamp(this.mSamplesPointer);
            float[] converted = new float[4096];
            int samplesPointer = this.mSamplesPointer;
            for (int pointer = 0; pointer < converted.length; ++pointer) {
                converted[pointer] = LOOKUP_VALUES[0xFF & ByteNativeBuffer.this.mSamples[samplesPointer++]] - ByteNativeBuffer.this.mAverageDc;
            }
            this.mSamplesPointer = samplesPointer;
            return new InterleavedComplexSamples(converted, timestamp);
        }
    }
}

