/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.bits;

import io.github.dsheirer.bits.BinaryMessage;
import java.util.BitSet;

public class CorrectedBinaryMessage
extends BinaryMessage {
    private int mCorrectedBitCount;

    public CorrectedBinaryMessage(int size) {
        super(size);
    }

    public CorrectedBinaryMessage(int size, boolean[] bitsToPreload) {
        super(size, bitsToPreload);
    }

    public CorrectedBinaryMessage(BitSet bitset, int size) {
        super(bitset, size);
    }

    public CorrectedBinaryMessage(byte[] data) {
        super(data);
    }

    public CorrectedBinaryMessage(BinaryMessage message) {
        this(message.size());
        this.xor(message);
    }

    @Override
    public int getCorrectedBitCount() {
        return this.mCorrectedBitCount;
    }

    public void setCorrectedBitCount(int count) {
        this.mCorrectedBitCount = count;
    }

    public void incrementCorrectedBitCount(int additionalCount) {
        this.mCorrectedBitCount += additionalCount;
    }

    @Override
    public CorrectedBinaryMessage getSubMessage(int start, int end) {
        BinaryMessage subset = this.get(start, end);
        return new CorrectedBinaryMessage(subset, end - start);
    }
}

