/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.bits;

import io.github.dsheirer.bits.BitSetFullException;
import io.github.dsheirer.edac.CRC;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.BitSet;
import org.apache.commons.lang3.Validate;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryMessage
extends BitSet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryMessage.class);
    private static final int[] CHARACTER_7_BIT = new int[]{0, 1, 2, 3, 4, 5, 6};
    private static final int[] CHARACTER_8_BIT = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final String UTF_8 = "UTF-8";
    private static final String GB2312 = "GB2312";
    private int mSize;
    private int mPointer = 0;
    private CRC mCRC;

    public BinaryMessage(int size) {
        super(size);
        this.mSize = size;
    }

    public BinaryMessage(int size, boolean[] bitsToPreload) {
        this(size);
        for (int pointer = 0; !this.isFull() && pointer < bitsToPreload.length; ++pointer) {
            try {
                this.add(bitsToPreload[pointer]);
                continue;
            }
            catch (BitSetFullException e) {
                e.printStackTrace();
            }
        }
    }

    private BinaryMessage(BinaryMessage toCopyFrom) {
        this(toCopyFrom.size());
        this.or(toCopyFrom);
        this.mPointer = toCopyFrom.pointer();
        this.mCRC = toCopyFrom.mCRC;
        this.mSize = toCopyFrom.mSize;
    }

    public BinaryMessage(BitSet bitset, int size) {
        this(size);
        this.or(bitset);
        this.mPointer = size - 1;
    }

    public BinaryMessage(byte[] data) {
        this(BitSet.valueOf(data), data.length * 8);
    }

    public BinaryMessage getSubMessage(int start, int end) {
        BinaryMessage subset = this.get(start, end);
        return new BinaryMessage(subset, end - start);
    }

    public CRC getCRC() {
        return this.mCRC;
    }

    public void setCRC(CRC crc) {
        this.mCRC = crc;
    }

    public int getCorrectedBitCount() {
        return 0;
    }

    public int pointer() {
        return this.mPointer;
    }

    public void setPointer(int index) {
        this.mPointer = index;
    }

    public void adjustPointer(int adjustment) {
        this.mPointer += adjustment;
    }

    public static BinaryMessage merge(boolean[] preloadBits, BinaryMessage bitsetToAppend) {
        BinaryMessage returnValue = new BinaryMessage(preloadBits.length + bitsetToAppend.size(), preloadBits);
        for (int pointer = 0; pointer < bitsetToAppend.size() && !returnValue.isFull(); ++pointer) {
            try {
                returnValue.add(bitsetToAppend.get(pointer));
                continue;
            }
            catch (BitSetFullException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public BinaryMessage copy() {
        return new BinaryMessage(this);
    }

    public boolean isFull() {
        return this.mPointer >= this.mSize;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    public void setSize(int size) {
        this.mSize = size;
    }

    @Override
    public void clear() {
        this.clear(0, this.mSize);
        this.mPointer = 0;
    }

    public void add(boolean value) throws BitSetFullException {
        if (this.isFull()) {
            throw new BitSetFullException("bitset is full -- contains [" + this.mPointer + "/" + this.size() + "] bits");
        }
        this.set(this.mPointer++, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < this.mSize; ++x) {
            sb.append(this.get(x) ? "1" : "0");
        }
        return sb.toString();
    }

    public String toHexString() {
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < this.size(); x += 4) {
            sb.append(this.getNibbleAsHex(x));
        }
        return sb.toString();
    }

    @Override
    public BinaryMessage get(int from, int to) {
        return new BinaryMessage(super.get(from, to), to - from);
    }

    public int[] toIntegerArray() {
        int[] values = new int[this.mSize];
        int i = this.nextSetBit(0);
        while (i >= 0 && i < this.mSize) {
            values[i] = 1;
            i = this.nextSetBit(i + 1);
        }
        return values;
    }

    @Override
    public byte[] toByteArray() {
        int length = this.size() / 8;
        if (length * 8 < this.size()) {
            ++length;
        }
        byte[] bytes = new byte[length];
        int pointer = 0;
        for (int x = 0; x < length; ++x) {
            bytes[x] = this.getByte(pointer);
            pointer += 8;
        }
        return bytes;
    }

    public int[] toReverseIntegerArray(int start, int end) {
        int[] values = new int[end - start + 1];
        int i = this.nextSetBit(start);
        while (i >= start && i <= end) {
            values[end - i] = 1;
            i = this.nextSetBit(i + 1);
        }
        return values;
    }

    public boolean[] getBits(int startIndex) {
        return this.getBits(startIndex, this.mSize - 1);
    }

    public boolean[] right(int bitCount) {
        return this.getBits(this.mSize - bitCount - 1);
    }

    public boolean[] getBits(int startIndex, int endIndex) {
        boolean[] returnValue = null;
        if (startIndex >= 0 && startIndex < endIndex && endIndex < this.mSize) {
            returnValue = new boolean[endIndex - startIndex + 1];
            int bitsetPointer = startIndex;
            int returnPointer = 0;
            while (bitsetPointer <= endIndex) {
                returnValue[returnPointer] = this.get(bitsetPointer);
                ++bitsetPointer;
                ++returnPointer;
            }
        }
        return returnValue;
    }

    public int getInt(int[] bits) {
        if (bits.length > 32) {
            throw new IllegalArgumentException("Overflow - must be 32 bits or less to fit into a primitive integer value");
        }
        int value = 0;
        for (int index : bits) {
            value = Integer.rotateLeft(value, 1);
            if (!this.get(index)) continue;
            ++value;
        }
        return value;
    }

    public int getInt(int[] bits, int offset) {
        if (bits.length > 32) {
            throw new IllegalArgumentException("Overflow - must be 32 bits or less to fit into a primitive integer value");
        }
        int value = 0;
        for (int index : bits) {
            value = Integer.rotateLeft(value, 1);
            if (!this.get(index + offset)) continue;
            ++value;
        }
        return value;
    }

    public void setInt(int value, int[] indices) {
        for (int x = 0; x < indices.length; ++x) {
            int mask = 1 << indices.length - x - 1;
            if ((value & mask) == mask) {
                this.set(indices[x]);
                continue;
            }
            this.clear(indices[x]);
        }
    }

    public byte getByte(int[] bits) {
        if (bits.length != 8) {
            throw new IllegalArgumentException("Invalid - there must be 8indexes to form a proper byte");
        }
        int value = 0;
        for (int index : bits) {
            value = Integer.rotateLeft(value, 1);
            if (!this.get(index)) continue;
            ++value;
        }
        return (byte)(value & 0xFF);
    }

    public byte getByte(int[] bits, int offset) {
        if (bits.length != 8) {
            throw new IllegalArgumentException("Invalid - there must be 8indexes to form a proper byte");
        }
        int value = 0;
        for (int index : bits) {
            value = Integer.rotateLeft(value, 1);
            if (!this.get(index + offset)) continue;
            ++value;
        }
        return (byte)(value & 0xFF);
    }

    public byte getByte(int startIndex) {
        int value = 0;
        for (int x = 0; x < 8; ++x) {
            value <<= 1;
            int index = startIndex + x;
            if (index > this.size() || !this.get(index)) continue;
            ++value;
        }
        return (byte)value;
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[(int)FastMath.ceil((double)((double)this.size() / 8.0))];
        for (int x = 0; x < bytes.length; ++x) {
            bytes[x] = this.getByte(x * 8);
        }
        return bytes;
    }

    public int getNibble(int startIndex) {
        int value = 0;
        for (int x = 0; x < 4; ++x) {
            value <<= 1;
            int index = startIndex + x;
            if (index > this.size() || !this.get(index)) continue;
            ++value;
        }
        return value;
    }

    public void setByte(int index, byte value) {
        Validate.isTrue((index + 8 <= this.size() ? 1 : 0) != 0);
        int mask = 128;
        for (int x = 0; x < 8; ++x) {
            if ((mask & value) == mask) {
                this.set(index + x);
            } else {
                this.clear(index + x);
            }
            mask >>= 1;
        }
    }

    public long getLong(int[] bits) {
        if (bits.length > 64) {
            throw new IllegalArgumentException("Overflow - must be 64 bits or less to fit into a primitive long value");
        }
        long value = 0L;
        for (int index : bits) {
            value = Long.rotateLeft(value, 1);
            if (!this.get(index)) continue;
            ++value;
        }
        return value;
    }

    public long getLong(int[] bits, int offset) {
        if (bits.length > 64) {
            throw new IllegalArgumentException("Overflow - must be 64 bits or less to fit into a primitive long value");
        }
        long value = 0L;
        for (int index : bits) {
            value = Long.rotateLeft(value, 1);
            if (!this.get(index + offset)) continue;
            ++value;
        }
        return value;
    }

    public String getHex(int start, int end) {
        StringBuilder sb = new StringBuilder();
        for (int x = start; x <= end; x += 4) {
            sb.append(this.getNibbleAsHex(x));
        }
        return sb.toString();
    }

    public String getNibbleAsHex(int startIndex) {
        int value = this.getNibble(startIndex);
        return Integer.toHexString(value).toUpperCase();
    }

    public String getHex(int[] bits, int digitDisplayCount) {
        if (bits.length <= 32) {
            int value = this.getInt(bits);
            return String.format("%0" + digitDisplayCount + "X", value);
        }
        if (bits.length <= 64) {
            long value = this.getLong(bits);
            return String.format("%0" + digitDisplayCount + "X", value);
        }
        throw new IllegalArgumentException("BitSetBuffer.getHex() maximum array length is 63 bits");
    }

    public int getInt(int start, int end) {
        if (FastMath.abs((int)(end - start)) > 32) {
            throw new IllegalArgumentException("Overflow - must be 32 bits or less to fit into a primitive integer value");
        }
        int value = 0;
        if (start < end) {
            for (int x = start; x <= end; ++x) {
                value = Integer.rotateLeft(value, 1);
                if (!this.get(x)) continue;
                ++value;
            }
        } else {
            for (int x = end; x >= start; --x) {
                value = Integer.rotateLeft(value, 1);
                if (!this.get(x)) continue;
                ++value;
            }
        }
        return value;
    }

    public int getTwosComplement(int start, int end) {
        if (this.get(start)) {
            BinaryMessage fragment = this.getSubMessage(start, end);
            fragment.flip(0, fragment.size());
            return fragment.getInt(1, fragment.size()) + 1;
        }
        return this.getInt(start + 1, end);
    }

    public long getLong(int start, int end) {
        if (FastMath.abs((int)(end - start)) > 64) {
            throw new IllegalArgumentException("Overflow - must be 64 bits or less to fit into a primitive long value");
        }
        long value = 0L;
        if (start < end) {
            for (int x = start; x <= end; ++x) {
                value = Long.rotateLeft(value, 1);
                if (!this.get(x)) continue;
                ++value;
            }
        } else {
            for (int x = end; x >= start; --x) {
                value = Long.rotateLeft(value, 1);
                if (!this.get(x)) continue;
                ++value;
            }
        }
        return value;
    }

    public static BinaryMessage getBuffer(int width, long fill) {
        BinaryMessage buffer = new BinaryMessage(width);
        buffer.load(0, width, fill);
        return buffer;
    }

    public void load(int offset, int width, long value) {
        for (int x = 0; x < width; ++x) {
            long mask = Long.rotateLeft(1L, width - x - 1);
            if ((mask & value) == mask) {
                this.set(offset + x);
                continue;
            }
            this.clear(offset + x);
        }
    }

    public void load(int offset, BinaryMessage binaryMessage) {
        for (int x = 0; x < binaryMessage.size(); ++x) {
            if (binaryMessage.get(x)) {
                this.set(x + offset);
                continue;
            }
            this.clear(x + offset);
        }
    }

    public static int[] getFieldIndexes(int start, int length, boolean bigEndian) {
        int[] checksumIndexes = new int[length];
        for (int x = 0; x < length; ++x) {
            if (bigEndian) {
                checksumIndexes[length - x - 1] = start + x;
                continue;
            }
            checksumIndexes[x] = start + x;
        }
        return checksumIndexes;
    }

    public static BinaryMessage from(byte[] bytes) {
        BinaryMessage message = new BinaryMessage(bytes.length * 8);
        for (int x = 0; x < bytes.length; ++x) {
            message.setByte(x * 8, bytes[x]);
        }
        return message;
    }

    public static BinaryMessage load(String message) {
        if (!message.matches("[01]*")) {
            throw new IllegalArgumentException("Message must contain only zeros and ones");
        }
        BinaryMessage buffer = new BinaryMessage(message.length());
        for (int x = 0; x < message.length(); ++x) {
            if (!message.substring(x, x + 1).contentEquals("1")) continue;
            buffer.set(x);
        }
        return buffer;
    }

    public static BinaryMessage loadHex(String hex) {
        if (!hex.matches("[0-9A-F]*")) {
            throw new IllegalArgumentException("Message must contain only 0-9 and A-F hexadecimal characters");
        }
        int length = hex.length() / 2;
        if (length * 2 < hex.length()) {
            ++length;
        }
        BinaryMessage buffer = new BinaryMessage(length * 8);
        int bufferOffset = 0;
        for (int x = 0; x < hex.length(); x += 2) {
            Object rawHex;
            int endIndex = x + 2;
            if (endIndex > hex.length()) {
                --endIndex;
            }
            if (((String)(rawHex = hex.substring(x, endIndex))).length() == 1) {
                rawHex = (String)rawHex + "0";
            }
            int value = Integer.parseInt((String)rawHex, 16);
            buffer.setByte(bufferOffset, (byte)(value & 0xFF));
            bufferOffset += 8;
        }
        return buffer;
    }

    public void rotateLeft(int places, int startIndex, int endIndex) {
        for (int x = 0; x < places; ++x) {
            this.rotateLeft(startIndex, endIndex);
        }
    }

    public void rotateLeft(int startIndex, int endIndex) {
        boolean wrapBit = this.get(startIndex);
        for (int x = startIndex; x < endIndex; ++x) {
            if (this.get(x + 1)) {
                this.set(x);
                continue;
            }
            this.clear(x);
        }
        if (wrapBit) {
            this.set(endIndex);
        } else {
            this.clear(endIndex);
        }
    }

    public void rotateRight(int places, int startIndex, int endIndex) {
        for (int x = 0; x < places; ++x) {
            this.rotateRight(startIndex, endIndex);
        }
    }

    public void rotateRight(int startIndex, int endIndex) {
        boolean wrapBit = this.get(endIndex);
        for (int x = endIndex - 1; x >= startIndex; --x) {
            if (this.get(x)) {
                this.set(x + 1);
                continue;
            }
            this.clear(x + 1);
        }
        if (wrapBit) {
            this.set(startIndex);
        } else {
            this.clear(startIndex);
        }
    }

    public void xor(int offset, int width, int value) {
        BinaryMessage mask = new BinaryMessage(this.size());
        mask.load(offset, width, value);
        this.xor(mask);
    }

    public String parseISO7(int offset, int characterCount) {
        byte[] bytes = new byte[characterCount];
        for (int x = 0; x < characterCount; ++x) {
            bytes[x] = this.getByte(CHARACTER_7_BIT, x * 7 + offset);
        }
        return new String(bytes);
    }

    public String parseISO8(int offset, int characterCount) {
        byte[] bytes = new byte[characterCount];
        for (int x = 0; x < characterCount; ++x) {
            bytes[x] = this.getByte(CHARACTER_8_BIT, x * 8 + offset);
        }
        return new String(bytes);
    }

    public String parseUTF8(int offset, int characterCount) throws UnsupportedEncodingException {
        byte[] bytes = new byte[characterCount];
        for (int x = 0; x < characterCount; ++x) {
            bytes[x] = this.getByte(CHARACTER_8_BIT, x * 8 + offset);
        }
        return new String(bytes, UTF_8);
    }

    public String parseGB2312(int offset, int characterCount) throws UnsupportedEncodingException {
        int length = characterCount * 2;
        byte[] bytes = new byte[length];
        for (int x = 0; x < length; ++x) {
            bytes[x] = this.getByte(CHARACTER_8_BIT, x * 8 + offset);
        }
        return new String(bytes, GB2312);
    }

    public String parseUnicode(int offset, int characterCount) {
        int length = characterCount * 2;
        byte[] bytes = new byte[length];
        for (int x = 0; x < length; ++x) {
            bytes[x] = this.getByte(CHARACTER_8_BIT, x * 8 + offset);
        }
        return new String(bytes, Charset.forName("UTF-16"));
    }

    public String parseBCD4(int offset, int characterCount) {
        StringBuilder sb = new StringBuilder();
        for (int count = 0; count < characterCount; ++count) {
            int nibble = this.getNibble(offset);
            sb.append(Integer.toHexString(nibble).toUpperCase());
            offset += 4;
        }
        return sb.toString();
    }
}

