/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.playback;

import io.github.dsheirer.audio.AudioFormats;
import io.github.dsheirer.audio.playback.AudioOutput;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.mixer.MixerChannel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javax.sound.sampled.Mixer;

public class StereoAudioOutput
extends AudioOutput {
    private static final int BUFFER_SIZE = 16000;

    public StereoAudioOutput(Mixer mixer, MixerChannel channel, UserPreferences userPreferences) {
        super(mixer, channel, AudioFormats.PCM_SIGNED_8000_HZ_16BITS_STEREO, AudioFormats.STEREO_SOURCE_DATALINE_INFO, 16000, userPreferences);
    }

    @Override
    protected ByteBuffer convert(float[] samples) {
        ByteBuffer buffer;
        block4: {
            buffer = null;
            if (samples.length <= 0) break block4;
            buffer = ByteBuffer.allocate(samples.length * 4).order(ByteOrder.LITTLE_ENDIAN);
            ShortBuffer shortBuffer = buffer.asShortBuffer();
            if (this.getMixerChannel() == MixerChannel.LEFT) {
                for (float sample : samples) {
                    shortBuffer.put((short)(sample * 32767.0f));
                    shortBuffer.put((short)0);
                }
            } else {
                for (float sample : samples) {
                    shortBuffer.put((short)0);
                    shortBuffer.put((short)(sample * 32767.0f));
                }
            }
        }
        return buffer;
    }
}

