/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.playback;

import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.AudioEvent;
import io.github.dsheirer.audio.AudioException;
import io.github.dsheirer.audio.IAudioController;
import io.github.dsheirer.audio.playback.AudioChannelsPanel;
import io.github.dsheirer.audio.playback.AudioOutput;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.preference.PreferenceEditorType;
import io.github.dsheirer.gui.preference.ViewUserPreferenceEditorRequest;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.source.mixer.MixerChannelConfiguration;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.sound.sampled.FloatControl;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPanel
extends JPanel
implements Listener<AudioEvent> {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(AudioPanel.class);
    private static ImageIcon MUTED_ICON = IconModel.getScaledIcon("images/audio_muted.png", 20);
    private static ImageIcon UNMUTED_ICON = IconModel.getScaledIcon("images/audio_unmuted.png", 20);
    private IconModel mIconModel;
    private SettingsManager mSettingsManager;
    private IAudioController mController;
    private AliasModel mAliasModel;
    private UserPreferences mUserPreferences;
    private JButton mMuteButton;
    private AudioChannelsPanel mAudioChannelsPanel;

    public AudioPanel(IconModel iconModel, UserPreferences userPreferences, SettingsManager settingsManager, IAudioController controller, AliasModel aliasModel) {
        this.mIconModel = iconModel;
        this.mSettingsManager = settingsManager;
        this.mController = controller;
        this.mAliasModel = aliasModel;
        this.mUserPreferences = userPreferences;
        this.mController.addControllerListener(this);
        this.init();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[]0[grow,fill]", "[fill]0[]"));
        this.setBackground(Color.BLACK);
        this.mMuteButton = new MuteButton();
        this.mMuteButton.setBackground(this.getBackground());
        this.add(this.mMuteButton);
        this.mAudioChannelsPanel = new AudioChannelsPanel(this.mIconModel, this.mUserPreferences, this.mSettingsManager, this.mController, this.mAliasModel);
        this.add(this.mAudioChannelsPanel);
        this.addMouseListener(new MouseSelectionListener());
    }

    @Override
    public void receive(AudioEvent event) {
        switch (event.getType()) {
            case AUDIO_CONFIGURATION_CHANGE_STARTED: {
                break;
            }
            case AUDIO_CONFIGURATION_CHANGE_COMPLETE: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AudioPanel.this.remove(AudioPanel.this.mAudioChannelsPanel);
                        AudioPanel.this.mAudioChannelsPanel.dispose();
                        AudioPanel.this.mAudioChannelsPanel = new AudioChannelsPanel(AudioPanel.this.mIconModel, AudioPanel.this.mUserPreferences, AudioPanel.this.mSettingsManager, AudioPanel.this.mController, AudioPanel.this.mAliasModel);
                        AudioPanel.this.add(AudioPanel.this.mAudioChannelsPanel);
                        AudioPanel.this.mAudioChannelsPanel.repaint();
                        AudioPanel.this.revalidate();
                        AudioPanel.this.repaint();
                    }
                });
                break;
            }
        }
    }

    public class MuteButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private boolean mMuted = false;

        public MuteButton() {
            this.setIcon(UNMUTED_ICON);
            this.setBorderPainted(false);
            this.getAccessibleContext().setAccessibleName("Mute");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MuteButton.this.mMuted = !MuteButton.this.mMuted;
                    for (AudioOutput output : AudioPanel.this.mController.getAudioOutputs()) {
                        output.setMuted(MuteButton.this.mMuted);
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MuteButton.this.setIcon(MuteButton.this.mMuted ? MUTED_ICON : UNMUTED_ICON);
                            MuteButton.this.getAccessibleContext().setAccessibleName(MuteButton.this.mMuted ? "Unmute" : "Mute");
                        }
                    });
                }
            });
        }
    }

    public class MouseSelectionListener
    implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent event) {
            if (SwingUtilities.isRightMouseButton(event)) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem outputMenu = new JMenuItem("Configure ...");
                Icon icon = IconFontSwing.buildIcon((IconCode)FontAwesome.COG, (float)14.0f);
                outputMenu.setIcon(icon);
                outputMenu.addActionListener(new ActionListener(this){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MyEventBus.getGlobalEventBus().post((Object)new ViewUserPreferenceEditorRequest(PreferenceEditorType.AUDIO_OUTPUT));
                    }
                });
                popup.add(outputMenu);
                popup.add(new JPopupMenu.Separator());
                for (AudioOutput output : AudioPanel.this.mController.getAudioOutputs()) {
                    JMenu menu = new JMenu("Channel: " + output.getChannelName());
                    menu.add(new AudioOutputMuteItem(output));
                    if (output.hasGainControl()) {
                        JMenu volume = new JMenu("Volume");
                        volume.add(new VolumeSlider(output.getGainControl()));
                        menu.add(volume);
                    }
                    popup.add(menu);
                }
                popup.show(event.getComponent(), event.getX(), event.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    public class MixerSelectionItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        private MixerChannelConfiguration mConfiguration;

        public MixerSelectionItem(MixerChannelConfiguration config) {
            super(config.toString());
            this.mConfiguration = config;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        AudioPanel.this.mController.setMixerChannelConfiguration(MixerSelectionItem.this.mConfiguration);
                    }
                    catch (AudioException e1) {
                        mLog.error("Couldn't set mixer channel configuration to: " + MixerSelectionItem.this.mConfiguration.toString());
                        JOptionPane.showMessageDialog(MixerSelectionItem.this, "Couldn't set [" + MixerSelectionItem.this.mConfiguration.toString() + "] as the audio output device");
                    }
                }
            });
        }
    }

    public class VolumeSlider
    extends JSlider {
        private static final long serialVersionUID = 1L;
        private FloatControl mFloatControl;

        public VolumeSlider(FloatControl control) {
            super(0, 100, 0);
            this.setMajorTickSpacing(25);
            this.setMinorTickSpacing(5);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
            this.mFloatControl = control;
            this.setValue(this.getIntegerValue(this.mFloatControl.getValue()));
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent event) {
                    VolumeSlider.this.mFloatControl.shift(VolumeSlider.this.mFloatControl.getValue(), VolumeSlider.this.getFloatValue(VolumeSlider.this.getValue()), 1000);
                }
            });
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() == 2) {
                        VolumeSlider.this.setValue(50);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent arg0) {
                }

                @Override
                public void mousePressed(MouseEvent arg0) {
                }

                @Override
                public void mouseExited(MouseEvent arg0) {
                }

                @Override
                public void mouseEntered(MouseEvent arg0) {
                }
            });
        }

        private int getIntegerValue(float value) {
            if (value == 0.0f) {
                return 50;
            }
            if (value < 0.0f) {
                float ratio = value / this.mFloatControl.getMinimum();
                return 50 - (int)(ratio * 50.0f);
            }
            float ratio = value / this.mFloatControl.getMaximum();
            return 50 + (int)(ratio * 50.0f);
        }

        private float getFloatValue(int value) {
            if (value == 50) {
                return 0.0f;
            }
            if (value < 50) {
                return (float)(50 - value) / 50.0f * this.mFloatControl.getMinimum();
            }
            return (float)(value - 50) / 50.0f * this.mFloatControl.getMaximum();
        }
    }

    public class AudioOutputMuteItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        private AudioOutput mAudioOutput;

        public AudioOutputMuteItem(AudioOutput audioOutput) {
            super(audioOutput.isMuted() ? "Unmute" : "Mute");
            this.mAudioOutput = audioOutput;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AudioOutputMuteItem.this.mAudioOutput.setMuted(!AudioOutputMuteItem.this.mAudioOutput.isMuted());
                }
            });
        }
    }
}

