/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.playback;

import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.IAudioController;
import io.github.dsheirer.audio.playback.AudioChannelPanel;
import io.github.dsheirer.audio.playback.AudioOutput;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.settings.SettingsManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class AudioChannelsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    public AudioChannelsPanel(IconModel iconModel, UserPreferences userPreferences, SettingsManager settingsManager, IAudioController controller, AliasModel aliasModel) {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[][sizegroup abc,grow,fill][][sizegroup abc,grow,fill]", "[grow,fill]"));
        this.setBackground(Color.BLACK);
        List<AudioOutput> outputs = controller.getAudioOutputs();
        this.addSeparator();
        for (int x = 0; x < outputs.size(); ++x) {
            this.add(new AudioChannelPanel(iconModel, userPreferences, settingsManager, outputs.get(x), aliasModel));
            if (x >= outputs.size() - 1) continue;
            this.addSeparator();
        }
        if (outputs.size() == 1) {
            this.addSeparator();
            this.add((Component)new AudioChannelPanel(iconModel, userPreferences, settingsManager, null, aliasModel), "growx");
        }
    }

    public void dispose() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof AudioChannelPanel)) continue;
            ((AudioChannelPanel)component).dispose();
        }
    }

    private void addSeparator() {
        JSeparator separator = new JSeparator(1);
        separator.setBackground(Color.DARK_GRAY);
        this.add(separator);
    }
}

