/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.playback;

import com.google.common.base.Joiner;
import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.AudioEvent;
import io.github.dsheirer.audio.playback.AudioOutput;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.identifier.TalkgroupFormatPreference;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.settings.ColorSetting;
import io.github.dsheirer.settings.Setting;
import io.github.dsheirer.settings.SettingChangeListener;
import io.github.dsheirer.settings.SettingsManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioChannelPanel
extends JPanel
implements Listener<AudioEvent>,
SettingChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(AudioChannelPanel.class);
    public static final String PROPERTY_PREFIX = "audio.channel.panel.color.";
    public static final String PROPERTY_COLOR_BACKGROUND = "audio.channel.panel.color.background";
    public static final String PROPERTY_COLOR_LABEL = "audio.channel.panel.color.label";
    public static final String PROPERTY_COLOR_MUTED = "audio.channel.panel.color.muted";
    public static final String PROPERTY_COLOR_VALUE = "audio.channel.panel.color.value";
    private Font mFont = new Font("Monospaced", 0, 16);
    private Color mBackgroundColor;
    private Color mLabelColor;
    private Color mMutedColor;
    private Color mValueColor;
    private IconModel mIconModel;
    private SettingsManager mSettingsManager;
    private UserPreferences mUserPreferences;
    private TalkgroupFormatPreference mTalkgroupFormatPreference;
    private AudioOutput mAudioOutput;
    private JLabel mMutedLabel = new JLabel("M");
    private JLabel mChannelName = new JLabel(" ");
    private JLabel mIconLabel = new JLabel(" ");
    private JLabel mIdentifierLabel = new JLabel("-----");
    private Identifier mIdentifier;
    private List<Alias> mAliases = Collections.EMPTY_LIST;
    private AliasModel mAliasModel;
    private Lock mLock = new ReentrantLock();

    public AudioChannelPanel(IconModel iconModel, UserPreferences userPreferences, SettingsManager settingsManager, AudioOutput audioOutput, AliasModel aliasModel) {
        this.mIconModel = iconModel;
        this.mSettingsManager = settingsManager;
        this.mSettingsManager.addListener(this);
        this.mAliasModel = aliasModel;
        this.mUserPreferences = userPreferences;
        this.mTalkgroupFormatPreference = this.mUserPreferences.getTalkgroupFormatPreference();
        this.mAudioOutput = audioOutput;
        if (this.mAudioOutput != null) {
            this.mAudioOutput.addAudioEventListener(this);
            this.mAudioOutput.setIdentifierCollectionListener(new AudioMetadataProcessor());
        }
        this.mBackgroundColor = SystemProperties.getInstance().get(PROPERTY_COLOR_BACKGROUND, Color.BLACK);
        this.mLabelColor = SystemProperties.getInstance().get(PROPERTY_COLOR_LABEL, Color.LIGHT_GRAY);
        this.mMutedColor = SystemProperties.getInstance().get(PROPERTY_COLOR_MUTED, Color.RED);
        this.mValueColor = SystemProperties.getInstance().get(PROPERTY_COLOR_VALUE, Color.GREEN);
        this.init();
    }

    @Subscribe
    public void preferenceUpdated(PreferenceType preferenceType) {
        if (preferenceType == PreferenceType.TALKGROUP_FORMAT) {
            this.updateLabels();
        }
    }

    public void dispose() {
        MyEventBus.getGlobalEventBus().unregister((Object)this);
        if (this.mAudioOutput != null) {
            this.mAudioOutput.removeAudioEventListener(this);
            this.mAudioOutput.removeAudioMetadataListener();
        }
    }

    private void init() {
        MyEventBus.getGlobalEventBus().register((Object)this);
        this.setLayout((LayoutManager)new MigLayout("align center center, insets 0 0 0 0", "[][][align right]0[grow,fill]", ""));
        this.setBackground(this.mBackgroundColor);
        this.mMutedLabel.setFont(this.mFont);
        this.mMutedLabel.setForeground(this.mMutedColor);
        this.mMutedLabel.setVisible(false);
        this.add(this.mMutedLabel);
        this.mChannelName = new JLabel(this.mAudioOutput != null ? this.mAudioOutput.getChannelName() : " ");
        this.mChannelName.setFont(this.mFont);
        this.mChannelName.setForeground(this.mLabelColor);
        this.add(this.mChannelName);
        this.mIconLabel.setFont(this.mFont);
        this.mIconLabel.setForeground(this.mValueColor);
        this.add(this.mIconLabel);
        this.mIdentifierLabel.setFont(this.mFont);
        this.mIdentifierLabel.setForeground(this.mValueColor);
        this.add((Component)this.mIdentifierLabel, "wmin 10lp");
    }

    @Override
    public void receive(AudioEvent audioEvent) {
        switch (audioEvent.getType()) {
            case AUDIO_STOPPED: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AudioChannelPanel.this.resetLabels();
                    }
                });
                break;
            }
            case AUDIO_MUTED: 
            case AUDIO_UNMUTED: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AudioChannelPanel.this.mMutedLabel.setVisible(AudioChannelPanel.this.mAudioOutput.isMuted());
                    }
                });
                break;
            }
        }
    }

    private void resetLabels() {
        this.mLock.lock();
        try {
            boolean updated = this.mIdentifier != null;
            this.mIdentifier = null;
            this.mAliases = Collections.EMPTY_LIST;
            if (updated) {
                this.updateLabels();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIdentifiers(IdentifierCollection identifierCollection) {
        if (identifierCollection == null || identifierCollection.isEmpty()) {
            this.resetLabels();
            return;
        }
        List<Identifier> toIds = identifierCollection.getIdentifiers(IdentifierClass.USER, Role.TO);
        if (toIds.isEmpty()) {
            this.resetLabels();
            return;
        }
        boolean updated = false;
        this.mLock.lock();
        try {
            if (toIds.size() == 1) {
                Identifier currentIdentifier = this.mIdentifier;
                if (currentIdentifier == null || currentIdentifier != toIds.get(0)) {
                    this.mIdentifier = toIds.get(0);
                    AliasList aliasList = this.mAliasModel.getAliasList(identifierCollection);
                    if (aliasList != null) {
                        this.mAliases = aliasList.getAliases(this.mIdentifier);
                    }
                    updated = true;
                }
            } else {
                this.mIdentifier = toIds.get(0);
                AliasList aliasList = this.mAliasModel.getAliasList(identifierCollection);
                if (aliasList != null) {
                    this.mAliases = aliasList.getAliases(this.mIdentifier);
                }
                updated = true;
            }
            if (updated) {
                this.updateLabels();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLabels() {
        String identifier = null;
        String iconName = null;
        this.mLock.lock();
        try {
            if (this.mAliases.size() == 1) {
                identifier = this.mAliases.get(0).getName();
                iconName = this.mAliases.get(0).getIconName();
            } else if (this.mAliases.size() > 1) {
                identifier = Joiner.on((String)", ").skipNulls().join(this.mAliases);
            }
            if (identifier == null && this.mIdentifier != null) {
                identifier = this.mTalkgroupFormatPreference.format(this.mIdentifier);
            }
            if (identifier == null) {
                identifier = "-----";
            }
            ImageIcon icon = iconName != null ? this.mIconModel.getIcon(iconName, 18) : null;
            String identifierText = identifier;
            EventQueue.invokeLater(() -> {
                this.mIdentifierLabel.setText(identifierText);
                this.mIconLabel.setIcon(icon);
            });
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public void settingChanged(Setting setting) {
        if (setting instanceof ColorSetting) {
            ColorSetting colorSetting = (ColorSetting)setting;
            switch (colorSetting.getColorSettingName()) {
                case CHANNEL_STATE_LABEL_DECODER: {
                    EventQueue.invokeLater(() -> {
                        if (this.mIdentifierLabel != null) {
                            this.mIdentifierLabel.setForeground(this.mLabelColor);
                        }
                        if (this.mIconLabel != null) {
                            this.mIconLabel.setForeground(this.mLabelColor);
                        }
                    });
                    break;
                }
            }
        }
    }

    @Override
    public void settingDeleted(Setting setting) {
    }

    public class AudioMetadataProcessor
    implements Listener<IdentifierCollection> {
        @Override
        public void receive(IdentifierCollection identifierCollection) {
            AudioChannelPanel.this.updateIdentifiers(identifierCollection);
        }
    }
}

