/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert.thumbdv;

import com.fazecast.jSerialComm.SerialPort;
import io.github.dsheirer.audio.convert.thumbdv.message.AmbeMessage;
import io.github.dsheirer.audio.convert.thumbdv.message.AmbeMessageFactory;
import io.github.dsheirer.audio.convert.thumbdv.message.VocoderRate;
import io.github.dsheirer.audio.convert.thumbdv.message.request.AmbeRequest;
import io.github.dsheirer.audio.convert.thumbdv.message.request.DecodeSpeechRequest;
import io.github.dsheirer.audio.convert.thumbdv.message.request.EncodeSpeechRequest;
import io.github.dsheirer.audio.convert.thumbdv.message.request.ResetRequest;
import io.github.dsheirer.audio.convert.thumbdv.message.request.SetVocoderParametersRequest;
import io.github.dsheirer.audio.convert.thumbdv.message.request.SetVocoderRequest;
import io.github.dsheirer.audio.convert.thumbdv.message.response.DecodeSpeechResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.ReadyResponse;
import io.github.dsheirer.audio.convert.thumbdv.message.response.SetVocoderParameterResponse;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.util.ThreadPool;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbDv
implements AutoCloseable {
    private static final Logger mLog = LoggerFactory.getLogger(ThumbDv.class);
    private static final String PORT_DESCRIPTION = "USB-to-Serial Port (ftdi_sio)";
    private static final String PORT_DESCRIPTION_FRAGMENT = "USB Serial Port";
    private static final int BAUD_RATE = 460800;
    private static final byte PACKET_START = 97;
    private SerialPort mSerialPort;
    private ScheduledFuture mSerialPortReaderHandle;
    private ScheduledFuture mAudioDecodeProcessorHandle;
    private LinkedTransferQueue<DecodeSpeechRequest> mDecodeSpeechRequests = new LinkedTransferQueue();
    private AudioProtocol mAudioProtocol;
    private Listener<float[]> mAudioBufferListener;
    private boolean mStarted;

    public ThumbDv(AudioProtocol audioProtocol, Listener<float[]> listener) {
        this.mAudioProtocol = audioProtocol;
        this.mAudioBufferListener = listener;
    }

    public void decode(byte[] codecFrame) {
        if (!this.mStarted || this.mSerialPort == null) {
            throw new IllegalStateException("Must invoke start() method and thumbdv serial device must be available");
        }
        this.mDecodeSpeechRequests.offer(new DecodeSpeechRequest(codecFrame));
    }

    @Override
    public void close() throws IOException {
        if (this.mSerialPortReaderHandle != null) {
            this.mSerialPortReaderHandle.cancel(true);
            this.mSerialPortReaderHandle = null;
        }
        if (this.mSerialPort != null) {
            this.mSerialPort.closePort();
        }
    }

    public void start() throws IOException {
        if (this.mSerialPort == null) {
            SerialPort[] ports;
            for (SerialPort port : ports = SerialPort.getCommPorts()) {
                mLog.debug("Serial Port Name:" + port.getDescriptivePortName());
                if (!port.getDescriptivePortName().contentEquals(PORT_DESCRIPTION) && !port.getDescriptivePortName().contains(PORT_DESCRIPTION_FRAGMENT)) continue;
                this.mSerialPort = port;
                this.mSerialPort.setBaudRate(460800);
                this.mSerialPort.openPort(0, 5000, 10000);
                if (this.mSerialPort.isOpen()) {
                    mLog.info("Resetting ThumbDv Device");
                    this.send(new ResetRequest());
                    mLog.info("Creating Serial Port Reader");
                    SerialPortReader r = new SerialPortReader(this.mSerialPort.getInputStream());
                    mLog.info("Starting Serial Port Reader");
                    this.mSerialPortReaderHandle = ThreadPool.SCHEDULED.scheduleAtFixedRate(r, 0L, 5L, TimeUnit.MILLISECONDS);
                    this.mStarted = true;
                    mLog.info("Startup complete - awaiting reset response");
                    break;
                }
                mLog.warn("Could not open serial port: " + this.mSerialPort.getSystemPortName());
                throw new IOException("Could not open serial port:" + this.mSerialPort.getSystemPortName());
            }
        }
        if (this.mSerialPort == null) {
            throw new IOException("ThumbDV serial port not found");
        }
    }

    public void send(byte[] message) throws IOException {
        if (this.mSerialPort == null) {
            throw new IOException("ThumbDv must be started before use");
        }
        int bytesWritten = this.mSerialPort.writeBytes(message, (long)message.length);
        if (bytesWritten < 0) {
            throw new IOException("Unable to write message:" + Arrays.toString(message));
        }
        if (bytesWritten != message.length) {
            throw new IOException("Unable to write message:" + Arrays.toString(message) + " Bytes Written:" + bytesWritten);
        }
    }

    public void send(AmbeRequest request) throws IOException {
        this.send(request.getData());
    }

    private void receive(byte[] bytes) {
        AmbeMessage message = AmbeMessageFactory.getMessage(bytes);
        if (message instanceof DecodeSpeechResponse && this.mAudioBufferListener != null) {
            float[] samples = ((DecodeSpeechResponse)message).getSamples();
            this.mAudioBufferListener.receive(samples);
        } else if (message instanceof ReadyResponse && this.mAudioDecodeProcessorHandle == null) {
            if (this.mAudioDecodeProcessorHandle == null) {
                try {
                    switch (this.mAudioProtocol) {
                        case DSTAR: {
                            this.send(new SetVocoderRequest(VocoderRate.RATE_33));
                            this.send(new SetVocoderParametersRequest(304, 1891, 16384, 0, 0, 72));
                            break;
                        }
                        case DMR: 
                        case NXDN: 
                        case P25_PHASE2: {
                            this.send(new SetVocoderRequest(VocoderRate.RATE_33));
                            this.send(new SetVocoderParametersRequest(1073, 1876, 9216, 0, 0, 28488));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unrecognized audio protocol:" + String.valueOf((Object)this.mAudioProtocol));
                        }
                    }
                }
                catch (IOException ioe) {
                    mLog.error("Error setting audio protocol vocoder parameters");
                }
                mLog.info("ThumbDv Reset Complete");
            } else {
                mLog.info("ThumbDv Reset Detected");
            }
        } else if (message instanceof SetVocoderParameterResponse) {
            if (((SetVocoderParameterResponse)message).isSuccessful()) {
                mLog.info("Audio vocoder parameters configured for " + String.valueOf((Object)this.mAudioProtocol));
                this.mAudioDecodeProcessorHandle = ThreadPool.SCHEDULED.scheduleAtFixedRate(new AudioDecodeProcessor(), 0L, 10L, TimeUnit.MILLISECONDS);
            }
        } else if (message != null) {
            mLog.debug("RECEIVED:" + message.toString());
        }
    }

    public void logSerialPort() {
        if (this.mSerialPort != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nPort:\t\t\t").append(this.mSerialPort.getSystemPortName()).append("\n");
            sb.append("Name:\t\t\t").append(this.mSerialPort.getDescriptivePortName()).append("\n");
            sb.append("Baud Rate:\t\t").append(this.mSerialPort.getBaudRate()).append("\n");
            sb.append("Data Bits:\t\t").append(this.mSerialPort.getNumDataBits()).append("\n");
            sb.append("Parity Bits:\t").append(this.mSerialPort.getParity()).append("\n");
            sb.append("Stop Bits:\t\t").append(this.mSerialPort.getNumStopBits()).append("\n");
            sb.append("Flow Control:\t").append(this.mSerialPort.getFlowControlSettings()).append("\n");
            sb.append("Is Open:\t\t").append(this.mSerialPort.isOpen()).append("\n");
            mLog.info(sb.toString());
        } else {
            mLog.info("No serial port found");
        }
    }

    public static void main(String[] args) {
        mLog.debug("Starting");
        String silence = "BEDDEA821EFD660C08";
        String[] frames = new String[]{"0E46122323067C60F8", "0E469433C1067CF1BC", "0E46122B23067C60F8", "0E67162BE08874E2B4", "0E46163BE1067CF1BC", "0E46122B23067C60F8", "0A06163BE00A5C303E", "0E46122B23067C60F8", "0E46163BE1847CE1FC", "0E46122B23067C60F8"};
        ArrayList<byte[]> frameData = new ArrayList<byte[]>();
        for (String frame : frames) {
            byte[] bytes = new byte[frame.length() / 2];
            for (int x = 0; x < frame.length(); x += 2) {
                String hex = frame.substring(x, x + 2);
                bytes[x / 2] = (byte)(0xFF & Integer.parseInt(hex, 16));
            }
            frameData.add(bytes);
        }
        mLog.debug("Starting thumb dv thread(s)");
        Listener<float[]> listener = packet -> mLog.info("Got an audio packet!");
        try {
            ThumbDv thumbDv = new ThumbDv(AudioProtocol.P25_PHASE2, listener);
            try {
                thumbDv.start();
                Thread.sleep(6000L);
                for (int x = 0; x < 20; ++x) {
                    thumbDv.send(new EncodeSpeechRequest(new short[160]));
                    Thread.sleep(20L);
                }
                while (true) {
                    // Infinite loop
                }
            }
            catch (Throwable throwable) {
                try {
                    thumbDv.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            mLog.error("Error", (Throwable)ioe);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static enum AudioProtocol {
        DMR,
        DSTAR,
        NXDN,
        P25_PHASE2;

    }

    public class SerialPortReader
    implements Runnable {
        private InputStream mInputStream;

        public SerialPortReader(InputStream inputStream) {
            this.mInputStream = inputStream;
        }

        @Override
        public void run() {
            block15: {
                try {
                    if (this.mInputStream == null) break block15;
                    try {
                        while (this.mInputStream.available() > 0) {
                            byte[] buffer = new byte[400];
                            int bytesRead = this.mInputStream.readNBytes(buffer, 0, 1);
                            if (bytesRead == 1 && buffer[0] == 97) {
                                while (this.mInputStream.available() < 2) {
                                    try {
                                        Thread.sleep(1L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                bytesRead = this.mInputStream.readNBytes(buffer, 1, 2);
                                if (bytesRead == 2) {
                                    int length = (0xFF & buffer[1]) << 8;
                                    if (0 < (length += 0xFF & buffer[2]) && length < 400) {
                                        ++length;
                                        while (this.mInputStream.available() < length) {
                                            try {
                                                Thread.sleep(1L);
                                            }
                                            catch (InterruptedException interruptedException) {}
                                        }
                                        bytesRead = this.mInputStream.readNBytes(buffer, 3, length);
                                        if (bytesRead == length) {
                                            ThumbDv.this.receive(Arrays.copyOf(buffer, length + 3));
                                            continue;
                                        }
                                        mLog.debug("Expected [" + length + "] but received [" + bytesRead + "] bytes - " + Arrays.toString(buffer));
                                        continue;
                                    }
                                    mLog.error("Received packet with unexpected length: " + length);
                                    continue;
                                }
                                mLog.debug("Expected [2] but received [" + bytesRead + "] -- this shouldn't happen");
                                continue;
                            }
                            mLog.debug("Unrecognized byte: " + Arrays.toString(buffer));
                        }
                    }
                    catch (IOException ioe) {
                        mLog.error("Error while reading ThumbDv serial port", (Throwable)ioe);
                    }
                }
                catch (Throwable t) {
                    mLog.error("Error", t);
                }
            }
        }
    }

    public class AudioDecodeProcessor
    implements Runnable {
        @Override
        public void run() {
            try {
                DecodeSpeechRequest request = ThumbDv.this.mDecodeSpeechRequests.poll();
                if (request != null) {
                    try {
                        ThumbDv.this.send(request);
                    }
                    catch (IOException ioe) {
                        mLog.error("Error decoding audio frame", (Throwable)ioe);
                    }
                }
            }
            catch (Throwable t) {
                mLog.error("Error", t);
            }
        }
    }
}

