/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert;

import io.github.dsheirer.audio.convert.ISilenceGenerator;
import io.github.dsheirer.audio.convert.InputAudioFormat;
import io.github.dsheirer.audio.convert.MP3AudioConverter;
import io.github.dsheirer.audio.convert.MP3AudioFrames;
import io.github.dsheirer.audio.convert.MP3FrameTools;
import io.github.dsheirer.audio.convert.MP3Setting;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MP3SilenceGenerator
implements ISilenceGenerator {
    private static final Logger mLog = LoggerFactory.getLogger(MP3SilenceGenerator.class);
    private MP3AudioConverter mMP3AudioConverter;
    private InputAudioFormat mInputAudioFormat;
    private byte[] mSilenceFrame;
    private int mSilenceFrameDuration;

    public MP3SilenceGenerator(InputAudioFormat inputAudioFormat, MP3Setting setting) {
        this.mInputAudioFormat = inputAudioFormat;
        this.mMP3AudioConverter = new MP3AudioConverter(inputAudioFormat, setting, false);
        this.generate_frame();
    }

    private void generate_frame() {
        int chunk;
        int length = (int)InputAudioFormat.SR_8000.getSampleRate();
        ArrayList<float[]> silenceBuffers = new ArrayList<float[]>();
        for (int added = 0; added < length; added += chunk) {
            chunk = Math.min(length - added, 256);
            silenceBuffers.add(new float[chunk]);
        }
        List<byte[]> mp3Audio = this.mMP3AudioConverter.convert(silenceBuffers);
        byte[] silence = new byte[]{};
        for (byte[] mp3Chunk : mp3Audio) {
            silence = MP3SilenceGenerator.merge(silence, mp3Chunk);
        }
        MP3AudioFrames mp3Frames = MP3FrameTools.split(silence);
        if (mp3Frames.hasNextFrame()) {
            mp3Frames.nextFrame();
            this.mSilenceFrame = mp3Frames.getCurrentFrame();
            this.mSilenceFrameDuration = mp3Frames.getCurrentFrameDuration();
        }
    }

    @Override
    public MP3AudioFrames generate(long duration_ms) {
        ArrayList<byte[]> silenceFrames = new ArrayList<byte[]>();
        int silenceDuration = 0;
        while ((long)silenceDuration < duration_ms) {
            silenceFrames.add(this.mSilenceFrame);
            silenceDuration += this.mSilenceFrameDuration;
        }
        return new MP3AudioFrames(silenceDuration, silenceFrames);
    }

    private static byte[] merge(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }
}

