/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert;

import io.github.dsheirer.audio.convert.InputAudioFormat;
import java.util.Arrays;
import java.util.List;

public enum MP3Setting {
    CBR_16(false, 16, "CBR - Constant Bit Rate 16 kbps (default)"),
    CBR_32(false, 32, "CBR - Constant Bit Rate 32 kbps"),
    ABR_56(true, 56, "ABR - Average Bit Rate 56 kbps"),
    VBR_5(true, 5, "VBR - Variable Bit Rate - Better Quality"),
    VBR_7(true, 7, "VBR - Variable Bit Rate - Good Quality");

    private boolean mVariableBitRate;
    private int mSetting;
    private String mLabel;

    private MP3Setting(boolean variableBitRate, int setting, String label) {
        this.mVariableBitRate = variableBitRate;
        this.mSetting = setting;
        this.mLabel = label;
    }

    public static MP3Setting getDefault() {
        return CBR_16;
    }

    public boolean isVariableBitRate() {
        return this.mVariableBitRate;
    }

    public int getSetting() {
        return this.mSetting;
    }

    public List<InputAudioFormat> getSupportedSampleRates() {
        switch (this) {
            case CBR_16: {
                return InputAudioFormat.SAMPLE_RATES_8_16.stream().toList();
            }
            case CBR_32: 
            case VBR_7: {
                return InputAudioFormat.SAMPLE_RATES_8_16_22.stream().toList();
            }
        }
        return Arrays.stream(InputAudioFormat.values()).toList();
    }

    public String toString() {
        return this.mLabel;
    }
}

