/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert;

import io.github.dsheirer.audio.convert.ChannelMode;
import io.github.dsheirer.audio.convert.MP3BitRate;
import io.github.dsheirer.audio.convert.MP3SampleRate;
import io.github.dsheirer.audio.convert.MPEGLayer;
import io.github.dsheirer.audio.convert.MPEGVersion;
import org.apache.commons.math3.util.FastMath;

public class MP3Header {
    private MP3Header() {
    }

    public static boolean isValid(byte[] frame, int offset) {
        return frame.length >= offset + 4 && MP3Header.hasSync(frame, offset);
    }

    public static boolean hasSync(byte[] frame, int offset) {
        return (frame[offset] & 0xFF) == 255 && (frame[offset + 1] & 0xE0) == 224;
    }

    public static MPEGVersion getMPEGVersion(byte[] frame, int offset) {
        return MPEGVersion.fromValue((frame[offset + 1] & 0x18) >> 3);
    }

    public static MPEGLayer getMPEGLayer(byte[] frame, int offset) {
        return MPEGLayer.fromValue((frame[offset + 1] & 6) >> 1);
    }

    public static int getBitRate(byte[] frame, int offset) {
        return MP3BitRate.getLayer3BitRate(MP3Header.getMPEGVersion(frame, offset), (frame[offset + 2] & 0xF0) >> 4);
    }

    public static int getSampleRate(byte[] frame, int offset) {
        return MP3SampleRate.getSampleRate(MP3Header.getMPEGVersion(frame, offset), (frame[offset + 2] & 0xC) >> 2);
    }

    public static ChannelMode getChannelMode(byte[] frame, int offset) {
        return ChannelMode.fromValue((frame[offset + 3] & 0xC0) >> 6);
    }

    public static boolean isPadded(byte[] frame, int offset) {
        return (frame[offset + 2] & 2) == 2;
    }

    public static int getFrameLength(byte[] frame, int offset) {
        return MP3Header.getFrameSamples(frame, offset) / 8 * (MP3Header.getBitRate(frame, offset) * 1000) / MP3Header.getSampleRate(frame, offset) + (MP3Header.isPadded(frame, offset) ? 1 : 0);
    }

    public static int getFrameSamples(byte[] frame, int offset) {
        switch (MP3Header.getMPEGVersion(frame, offset)) {
            case V_1: {
                switch (MP3Header.getMPEGLayer(frame, offset)) {
                    case LAYER1: {
                        return 384;
                    }
                    case LAYER2: {
                        return 1152;
                    }
                    case LAYER3: {
                        return 1152;
                    }
                }
            }
            case V_2: 
            case V_2_5: {
                switch (MP3Header.getMPEGLayer(frame, offset)) {
                    case LAYER1: {
                        return 384;
                    }
                    case LAYER2: {
                        return 1152;
                    }
                    case LAYER3: {
                        return 576;
                    }
                }
            }
        }
        return 0;
    }

    public static int getFrameDuration(byte[] frame, int offset) {
        return (int)FastMath.round((double)((double)MP3Header.getFrameSamples(frame, offset) / (double)MP3Header.getSampleRate(frame, offset) * 1000.0));
    }

    public static String inspect(byte[] frame, int offset) {
        StringBuilder sb = new StringBuilder();
        sb.append("MP3 FRAME");
        if (!MP3Header.isValid(frame, offset)) {
            sb.append(" INVALID");
            return sb.toString();
        }
        sb.append(" VER:").append((Object)MP3Header.getMPEGVersion(frame, offset));
        sb.append(" MODE:").append((Object)MP3Header.getChannelMode(frame, offset));
        sb.append(" ").append((Object)MP3Header.getMPEGLayer(frame, offset));
        sb.append(" BR:").append(MP3Header.getBitRate(frame, offset));
        sb.append(" SR:").append(MP3Header.getSampleRate(frame, offset));
        return sb.toString();
    }
}

