/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert;

import io.github.dsheirer.audio.convert.MP3Header;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MP3FrameInspector {
    private static final Logger mLog = LoggerFactory.getLogger(MP3FrameInspector.class);

    public static void inspect(List<byte[]> frames) {
        if (frames.isEmpty()) {
            mLog.info("No Frame Data!");
            return;
        }
        for (byte[] frame : frames) {
            StringBuilder sb = new StringBuilder();
            int frameCounter = 0;
            for (int x = 0; x < frame.length; ++x) {
                if (MP3Header.isValid(frame, x)) {
                    sb.append("\n").append(++frameCounter).append(": ");
                    sb.append(MP3Header.inspect(frame, x)).append(" - ");
                }
                sb.append(String.format("%02X ", frame[x]));
            }
            mLog.info(sb.toString());
        }
    }
}

