/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.convert;

import io.github.dsheirer.audio.AudioFormats;
import java.util.EnumSet;
import javax.sound.sampled.AudioFormat;

public enum InputAudioFormat {
    SR_8000(AudioFormats.PCM_SIGNED_8000_HZ_16_BIT_MONO, "16-Bit 8000 Hz (no resample)"),
    SR_16000(AudioFormats.PCM_SIGNED_16000_HZ_16_BIT_MONO, "16-Bit 16000 Hz (default)"),
    SR_22050(AudioFormats.PCM_SIGNED_22050_HZ_16_BIT_MONO, "16-Bit 22050 Hz"),
    SR_44100(AudioFormats.PCM_SIGNED_44100_HZ_16_BIT_MONO, "16-Bit 44100 Hz"),
    SR_32_8000(AudioFormats.PCM_SIGNED_8000_HZ_32_BIT_MONO, "32-Bit 8000 Hz (no resample)"),
    SR_32_16000(AudioFormats.PCM_SIGNED_16000_HZ_32_BIT_MONO, "32-Bit 16000 Hz"),
    SR_32_22050(AudioFormats.PCM_SIGNED_22050_HZ_32_BIT_MONO, "32-Bit 22050 Hz"),
    SR_32_44100(AudioFormats.PCM_SIGNED_44100_HZ_32_BIT_MONO, "32-Bit 44100 Hz");

    private AudioFormat mAudioFormat;
    private String mLabel;
    public static final EnumSet<InputAudioFormat> SAMPLE_RATES_8_16;
    public static final EnumSet<InputAudioFormat> SAMPLE_RATES_8_16_22;

    private InputAudioFormat(AudioFormat audioFormat, String label) {
        this.mAudioFormat = audioFormat;
        this.mLabel = label;
    }

    public static InputAudioFormat getDefault() {
        return SR_16000;
    }

    public AudioFormat getAudioFormat() {
        return this.mAudioFormat;
    }

    public double getSampleRate() {
        return this.getAudioFormat().getSampleRate();
    }

    public String toString() {
        return this.mLabel;
    }

    static {
        SAMPLE_RATES_8_16 = EnumSet.of(SR_8000, SR_32_8000, SR_16000, SR_32_16000);
        SAMPLE_RATES_8_16_22 = EnumSet.of(SR_8000, new InputAudioFormat[]{SR_32_8000, SR_16000, SR_32_16000, SR_22050, SR_32_22050});
    }
}

