/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.codec.mbe;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.dsheirer.audio.codec.mbe.MBECallSequence;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.IMessageListener;
import io.github.dsheirer.module.Module;
import io.github.dsheirer.preference.TimestampFormat;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.sample.Listener;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MBECallSequenceRecorder
extends Module
implements IMessageListener,
Listener<IMessage> {
    private static final Logger mLog = LoggerFactory.getLogger(MBECallSequenceRecorder.class);
    protected static final String CALL_TYPE_GROUP = "GROUP";
    protected static final String CALL_TYPE_INDIVIDUAL = "INDIVIDUAL";
    protected static final String CALL_TYPE_TELEPHONE_INTERCONNECT = "TELEPHONE INTERCONNECT";
    protected UserPreferences mUserPreferences;
    protected long mChannelFrequency;
    protected String mSystem;
    protected String mSite;
    private int mCallNumber = 1;

    public MBECallSequenceRecorder(UserPreferences userPreferences, long channelFrequency, String system, String site) {
        this.mUserPreferences = userPreferences;
        this.mChannelFrequency = channelFrequency;
        this.mSystem = system;
        this.mSite = site;
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
    }

    protected void writeCallSequence(MBECallSequence sequence) {
        this.writeCallSequence(sequence, null);
    }

    protected void writeCallSequence(MBECallSequence sequence, String optionalChannelTag) {
        if (sequence != null && sequence.hasAudio()) {
            sequence.setSystem(this.mSystem);
            sequence.setSite(this.mSite);
            StringBuilder sb = new StringBuilder();
            sb.append(TimestampFormat.TIMESTAMP_COMPACT.getFormatter().format(new Date(System.currentTimeMillis())));
            sb.append("_").append(this.mChannelFrequency);
            sb.append("_").append(this.mCallNumber++);
            if (this.mCallNumber < 1) {
                this.mCallNumber = 1;
            }
            if (optionalChannelTag != null) {
                sb.append("_").append(optionalChannelTag);
            }
            if (sequence.getToIdentifier() != null) {
                sb.append("_").append(sequence.getToIdentifier().replace(":", ""));
            }
            if (sequence.getFromIdentifier() != null) {
                sb.append("_").append(sequence.getFromIdentifier().replace(":", ""));
            }
            if (sequence.isEncrypted()) {
                sb.append("_encrypted");
            }
            sb.append(".mbe");
            Path recordingDirectory = this.mUserPreferences.getDirectoryPreference().getDirectoryRecording();
            Path filePath = recordingDirectory.resolve(sb.toString());
            try {
                OutputStream outputStream = Files.newOutputStream(filePath, new OpenOption[0]);
                ObjectMapper mapper = new ObjectMapper();
                mapper.writerWithDefaultPrettyPrinter().writeValue(outputStream, (Object)sequence);
                outputStream.close();
            }
            catch (IOException ioe) {
                mLog.error("Couldn't write MBE call sequence to path [" + filePath.toString() + "]", (Throwable)ioe);
            }
        }
    }

    @Override
    public Listener<IMessage> getMessageListener() {
        return this;
    }
}

