/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.codec.mbe;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import io.github.dsheirer.audio.codec.mbe.MBECallSequence;
import io.github.dsheirer.module.decode.p25.audio.VoiceFrame;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MBECallSequenceReader {
    public static List<String> getAudioFrames(Path path) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Object obj = mapper.readValue(path.toFile(), MBECallSequence.class);
        if (obj instanceof MBECallSequence) {
            MBECallSequence sequence = (MBECallSequence)obj;
            ArrayList<String> audioFrames = new ArrayList<String>();
            for (VoiceFrame voiceFrame : sequence.getVoiceFrames()) {
                audioFrames.add(voiceFrame.getFrame());
            }
            return audioFrames;
        }
        return Collections.emptyList();
    }

    public static void main(String[] args) {
        Path path = Path.of("/home/denny/SDRTrunk/recordings/20190706063149_154250000_7_TS1_65084_6591001.mbe", new String[0]);
        try {
            List<String> frames = MBECallSequenceReader.getAudioFrames(path);
            Files.writeString(Path.of("/home/denny/SDRTrunk/recordings/mbe_frames.txt", new String[0]), (CharSequence)Joiner.on((String)"\",\n\"").join(frames), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

