/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.codec.mbe;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import io.github.dsheirer.audio.codec.mbe.IEncryptionSyncParameters;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.encryption.EncryptionKey;
import io.github.dsheirer.module.decode.p25.audio.VoiceFrame;
import java.util.ArrayList;
import java.util.List;

@JsonRootName(value="mbe_call")
@JsonPropertyOrder(value={"protocol", "call_type", "from", "to", "encrypted", "frames"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MBECallSequence {
    private String mProtocol;
    private String mFromIdentifier;
    private String mToIdentifier;
    private String mCallType;
    private String mSystem;
    private String mSite;
    private boolean mEncrypted;
    private List<VoiceFrame> mVoiceFrames = new ArrayList<VoiceFrame>();
    private IEncryptionSyncParameters mTemporaryEncryptionSyncParameters;

    public MBECallSequence(String protocol) {
        this.mProtocol = protocol;
    }

    public MBECallSequence() {
    }

    @JsonProperty(value="protocol")
    public String getProtocol() {
        return this.mProtocol;
    }

    public void setProtocol(String protocol) {
        this.mProtocol = protocol;
    }

    @JsonIgnore
    public boolean hasAudio() {
        return this.mVoiceFrames.size() > 4;
    }

    @JsonProperty(value="encrypted")
    public boolean isEncrypted() {
        return this.mEncrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.mEncrypted = encrypted;
    }

    public void setEncryptionSyncParameters(IEncryptionSyncParameters encryptionSyncParameters) {
        this.mTemporaryEncryptionSyncParameters = encryptionSyncParameters;
    }

    public void setFromIdentifier(String from) {
        if (from != null && !from.isEmpty() && !from.contentEquals("0")) {
            this.mFromIdentifier = from;
        }
    }

    public void setFromIdentifier(Identifier identifier) {
        if (identifier != null) {
            this.setFromIdentifier(identifier.toString());
        }
    }

    @JsonProperty(value="from")
    public String getFromIdentifier() {
        return this.mFromIdentifier;
    }

    public void setToIdentifier(String to) {
        if (to != null && !to.isEmpty() && !to.contentEquals("0")) {
            this.mToIdentifier = to;
        }
    }

    public void setToIdentifier(Identifier identifier) {
        if (identifier != null) {
            this.setToIdentifier(identifier.toString());
        }
    }

    @JsonProperty(value="to")
    public String getToIdentifier() {
        return this.mToIdentifier;
    }

    public void setCallType(String type) {
        this.mCallType = type;
    }

    @JsonProperty(value="call_type")
    public String getCallType() {
        return this.mCallType;
    }

    @JsonProperty(value="system")
    public String getSystem() {
        return this.mSystem;
    }

    public void setSystem(String system) {
        this.mSystem = system;
    }

    @JsonProperty(value="site")
    public String getSite() {
        return this.mSite;
    }

    public void setSite(String site) {
        this.mSite = site;
    }

    @JsonProperty(value="frames")
    public List<VoiceFrame> getVoiceFrames() {
        return this.mVoiceFrames;
    }

    public void setVoiceFrames(List<VoiceFrame> voiceFrames) {
        this.mVoiceFrames = voiceFrames;
    }

    public void addVoiceFrame(long timestamp, String frame) {
        if (this.mTemporaryEncryptionSyncParameters != null) {
            this.addEncryptedVoiceFrame(timestamp, frame, this.mTemporaryEncryptionSyncParameters);
            this.mTemporaryEncryptionSyncParameters = null;
        } else {
            this.mVoiceFrames.add(new VoiceFrame(timestamp, frame));
        }
    }

    public void addEncryptedVoiceFrame(long timestamp, String frame, IEncryptionSyncParameters parameters) {
        EncryptionKey encryption = (EncryptionKey)parameters.getEncryptionKey().getValue();
        this.addEncryptedVoiceFrame(timestamp, frame, encryption.getAlgorithm(), encryption.getKey(), parameters.getMessageIndicator());
        this.setEncrypted(true);
    }

    public void addEncryptedVoiceFrame(long timestamp, String frame, int algorithm, int keyid, String messageIndicator) {
        this.mVoiceFrames.add(new VoiceFrame(timestamp, frame, algorithm, keyid, messageIndicator));
    }
}

