/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.codec.mbe;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.audio.AbstractAudioModule;
import io.github.dsheirer.audio.squelch.ISquelchStateListener;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.IMessageListener;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.sample.Listener;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import jmbe.iface.IAudioCodec;
import jmbe.iface.IAudioCodecLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JmbeAudioModule
extends AbstractAudioModule
implements Listener<IMessage>,
IMessageListener,
ISquelchStateListener {
    private static final Logger mLog = LoggerFactory.getLogger(JmbeAudioModule.class);
    private static final String JMBE_AUDIO_LIBRARY = "JMBE";
    private static final List<String> mLibraryLoadStatusLogged = new ArrayList<String>();
    private IAudioCodec mAudioCodec;
    private final UserPreferences mUserPreferences;
    private static Class sLoadedJmbeAudioConverterClass;

    public JmbeAudioModule(UserPreferences userPreferences, AliasList aliasList, int timeslot) {
        super(aliasList, timeslot, 480000L);
        this.mUserPreferences = userPreferences;
        MyEventBus.getGlobalEventBus().register((Object)this);
        this.loadConverter();
    }

    @Override
    public void dispose() {
        super.dispose();
        MyEventBus.getGlobalEventBus().unregister((Object)this);
        this.mAudioCodec = null;
    }

    public IAudioCodec getAudioCodec() {
        return this.mAudioCodec;
    }

    protected boolean hasAudioCodec() {
        return this.getAudioCodec() != null;
    }

    @Override
    public Listener<IMessage> getMessageListener() {
        return this;
    }

    @Subscribe
    public void preferenceUpdated(PreferenceType preferenceType) {
        if (preferenceType == PreferenceType.JMBE_LIBRARY) {
            mLibraryLoadStatusLogged.clear();
            this.loadConverter();
        }
    }

    protected abstract String getCodecName();

    protected void loadConverter() {
        IAudioCodec audioConverter;
        block27: {
            block26: {
                Path path;
                audioConverter = null;
                if (sLoadedJmbeAudioConverterClass == null && (path = this.mUserPreferences.getJmbeLibraryPreference().getPathJmbeLibrary()) != null) {
                    if (!mLibraryLoadStatusLogged.contains(JMBE_AUDIO_LIBRARY)) {
                        mLog.info("Loading JMBE library from [" + String.valueOf(path) + "]");
                    }
                    try {
                        URLClassLoader childClassLoader = new URLClassLoader(new URL[]{path.toUri().toURL()}, this.getClass().getClassLoader());
                        sLoadedJmbeAudioConverterClass = Class.forName("jmbe.JMBEAudioLibrary", true, childClassLoader);
                    }
                    catch (IllegalArgumentException iae) {
                        if (!mLibraryLoadStatusLogged.contains(JMBE_AUDIO_LIBRARY + this.getCodecName())) {
                            mLog.error("Couldn't load JMBE audio conversion library - " + iae.getMessage());
                            mLibraryLoadStatusLogged.add(JMBE_AUDIO_LIBRARY + this.getCodecName());
                        }
                    }
                    catch (MalformedURLException mue) {
                        if (!mLibraryLoadStatusLogged.contains(JMBE_AUDIO_LIBRARY)) {
                            mLog.error("Couldn't load JMBE audio conversion library from path [" + String.valueOf(path) + "]");
                            mLibraryLoadStatusLogged.add(JMBE_AUDIO_LIBRARY);
                        }
                    }
                    catch (ClassNotFoundException e1) {
                        if (mLibraryLoadStatusLogged.contains(JMBE_AUDIO_LIBRARY)) break block26;
                        mLog.error("Couldn't load JMBE audio conversion library - class not found");
                        mLibraryLoadStatusLogged.add(JMBE_AUDIO_LIBRARY);
                    }
                }
            }
            if (sLoadedJmbeAudioConverterClass != null) {
                try {
                    Object instance = sLoadedJmbeAudioConverterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (instance instanceof IAudioCodecLibrary) {
                        IAudioCodecLibrary library = (IAudioCodecLibrary)instance;
                        if (library.getMajorVersion() == 1 && library.getMinorVersion() >= 0 && library.getBuildVersion() >= 0 || library.getMajorVersion() >= 1) {
                            audioConverter = library.getAudioConverter(this.getCodecName());
                            if (!mLibraryLoadStatusLogged.contains(JMBE_AUDIO_LIBRARY)) {
                                mLog.info("JMBE audio conversion library loaded: " + library.getVersion());
                                mLibraryLoadStatusLogged.add(JMBE_AUDIO_LIBRARY);
                            }
                        } else if (!mLibraryLoadStatusLogged.contains(JMBE_AUDIO_LIBRARY)) {
                            mLog.warn("JMBE library version 1.0.0 or higher is required - found: " + library.getVersion());
                            mLibraryLoadStatusLogged.add(JMBE_AUDIO_LIBRARY);
                        }
                    } else if (!mLibraryLoadStatusLogged.contains(JMBE_AUDIO_LIBRARY)) {
                        mLog.info("JMBE audio conversion library NOT FOUND");
                        mLibraryLoadStatusLogged.add(JMBE_AUDIO_LIBRARY);
                    }
                    break block27;
                }
                catch (InvocationTargetException ite) {
                    if (!mLibraryLoadStatusLogged.contains(JMBE_AUDIO_LIBRARY)) {
                        mLog.error("Couldn't load JMBE audio conversion library - invocation target exception", (Throwable)ite);
                        mLibraryLoadStatusLogged.add(JMBE_AUDIO_LIBRARY);
                    }
                    break block27;
                }
                catch (InstantiationException e1) {
                    if (!mLibraryLoadStatusLogged.contains(JMBE_AUDIO_LIBRARY)) {
                        mLog.error("Couldn't load JMBE audio conversion library - instantiation exception", (Throwable)e1);
                        mLibraryLoadStatusLogged.add(JMBE_AUDIO_LIBRARY);
                    }
                    break block27;
                }
                catch (IllegalAccessException e1) {
                    if (!mLibraryLoadStatusLogged.contains(JMBE_AUDIO_LIBRARY)) {
                        mLog.error("Couldn't load JMBE audio conversion library - security restrictions");
                        mLibraryLoadStatusLogged.add(JMBE_AUDIO_LIBRARY);
                    }
                    break block27;
                }
                catch (NoSuchMethodException nsme) {
                    if (!mLibraryLoadStatusLogged.contains(JMBE_AUDIO_LIBRARY)) {
                        mLog.error("Couldn't load JMBE audio conversion library - no such method exception");
                        mLibraryLoadStatusLogged.add(JMBE_AUDIO_LIBRARY);
                    }
                    break block27;
                }
            }
            if (!mLibraryLoadStatusLogged.contains(JMBE_AUDIO_LIBRARY)) {
                mLog.warn("JMBE audio library path is NOT SET in your User Preferences.");
                mLibraryLoadStatusLogged.add(JMBE_AUDIO_LIBRARY);
            }
        }
        this.mAudioCodec = audioConverter;
    }
}

