/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.codec.mbe;

import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.audio.codec.mbe.JmbeAudioModule;
import io.github.dsheirer.preference.UserPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AmbeAudioModule
extends JmbeAudioModule {
    private static final Logger mLog = LoggerFactory.getLogger(AmbeAudioModule.class);
    private static final String AMBE_CODEC = "AMBE 3600 x 2450";
    private static boolean sLibraryStatusLogged = false;

    public AmbeAudioModule(UserPreferences userPreferences, AliasList aliasList, int timeslot) {
        super(userPreferences, aliasList, timeslot);
        if (!sLibraryStatusLogged) {
            if (this.getAudioCodec() != null) {
                mLog.info("AMBE CODEC successfully loaded - P25-2/DMR/NXDN audio will be available");
            } else {
                mLog.warn("AMBE CODEC not loaded - P25-2/DMR/NXDN audio will NOT be available");
            }
            sLibraryStatusLogged = true;
        }
    }

    @Override
    protected String getCodecName() {
        return AMBE_CODEC;
    }
}

