/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox;

import java.io.UnsupportedEncodingException;

public enum UltravoxMetadata {
    ALBUM_TITLE("TALB"),
    ARTIST("TPE1"),
    AUDIO_SOURCE_WEBPAGE("WOAS"),
    BROADCAST_CLIENT_APPLICATION("TENC"),
    COMMENT("COMM"),
    CUSTOM_TEXT_FIELD("TXXX"),
    ENCODE_SETTINGS("TSSE"),
    GENERAL_BINARY_OBJECT("GEOB"),
    GENRE("TCON"),
    OWNER("TOWN"),
    RADIO_STATION("TRSN"),
    RADIO_STATION_OWNER("TRSO"),
    RADIO_STATION_WEBPAGE("WORS"),
    RECORDING_TIME("TDRC"),
    SOURCE_MEDIA_TYPE("TMED"),
    TITLE_1("TIT1"),
    TITLE_2("TIT2"),
    TITLE_3("TIT3"),
    URL("URL"),
    UNKNOWN("UNKNOWN");

    private String mXMLTag;

    private UltravoxMetadata(String xmlTag) {
        this.mXMLTag = xmlTag;
    }

    public String getXMLTag() {
        return this.mXMLTag;
    }

    public String asXML(String value) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.getXMLTag()).append(">");
        sb.append(new String(value.getBytes(), "UTF-8"));
        sb.append("</").append(this.getXMLTag()).append(">");
        return sb.toString();
    }
}

