/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox;

import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.UltravoxMessageClass;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ultravox.UltravoxMessageType;
import io.github.dsheirer.bits.BinaryMessage;
import java.util.Arrays;
import org.apache.commons.lang3.Validate;

public abstract class UltravoxMessage {
    public static final String ULTRAVOX_VERSION = "2.1";
    public static final String VALID_RESPONSE_PREFIX = "ACK";
    public static final String VALID_RESPONSE_PAYLOAD_PREFIX = "ACK:";
    public static final String ERROR_RESPONSE_PREFIX = "NAK:";
    public static final int[] SYNC = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    public static final int[] RESERVED = new int[]{8, 9, 10, 11};
    public static final int REQUIRED_DELIVERY = 12;
    public static final int[] SEND_QUEUE_PRIORITY = new int[]{13, 14, 15};
    public static final int[] MESSAGE_CLASS = new int[]{16, 17, 18, 19};
    public static final int[] MESSAGE_CLASS_AND_TYPE = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    public static final int[] PAYLOAD_LENGTH = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private BinaryMessage mMessage;

    public UltravoxMessage(byte[] data) {
        this.mMessage = new BinaryMessage(data.length * 8);
        int pointer = 0;
        for (byte b : data) {
            this.mMessage.setByte(pointer, b);
            pointer += 8;
        }
    }

    public UltravoxMessage(UltravoxMessageType ultravoxMessageType) {
        this.mMessage = new BinaryMessage(56);
        this.setSync();
        this.setMessageType(ultravoxMessageType);
    }

    public byte[] getMessage() {
        return this.mMessage.toByteArray();
    }

    public String toString() {
        return this.getMessageType().name();
    }

    private void setSync() {
        this.mMessage.setInt(90, SYNC);
    }

    public UltravoxMessageClass getMessageClass() {
        return UltravoxMessageClass.fromValue(this.mMessage.getInt(MESSAGE_CLASS));
    }

    public UltravoxMessageType getMessageType() {
        return UltravoxMessageType.fromValue(this.mMessage.getInt(MESSAGE_CLASS_AND_TYPE));
    }

    private void setMessageType(UltravoxMessageType messageType) {
        this.mMessage.setInt(messageType.getValue(), MESSAGE_CLASS_AND_TYPE);
    }

    public boolean isRequiredDelivery() {
        return this.mMessage.get(12);
    }

    public void setRequiredDelivery(boolean required) {
        if (required) {
            this.mMessage.set(12);
        } else {
            this.mMessage.clear(12);
        }
    }

    public int getSendQueuePriority() {
        return this.mMessage.getInt(SEND_QUEUE_PRIORITY);
    }

    public void setSendQueuePriority(int priority) {
        Validate.isTrue((0 <= priority && priority <= 7 ? 1 : 0) != 0);
        this.mMessage.setInt(priority, SEND_QUEUE_PRIORITY);
    }

    public String getPayload() {
        int payloadLength = this.mMessage.getInt(PAYLOAD_LENGTH);
        byte[] payload = new byte[payloadLength];
        int payloadPointer = 48;
        for (int x = 0; x < payloadLength; ++x) {
            payload[x] = this.mMessage.getByte(payloadPointer);
            payloadPointer += 8;
        }
        if (payload[payload.length - 1] == 0) {
            return new String(Arrays.copyOf(payload, payload.length - 1));
        }
        return new String(payload);
    }

    public void setPayload(String payload) {
        this.setPayload(payload.getBytes());
    }

    public void setPayload(byte[] payload) {
        int messageBitLength = (7 + payload.length) * 8;
        this.mMessage.setSize(messageBitLength);
        this.mMessage.setInt(payload.length, PAYLOAD_LENGTH);
        int payloadPointer = 48;
        for (byte payloadByte : payload) {
            this.mMessage.setByte(payloadPointer, payloadByte);
            payloadPointer += 8;
        }
        this.mMessage.setByte(payloadPointer, (byte)0);
    }

    public boolean isValidResponse() {
        String payload = this.getPayload();
        return payload != null && payload.startsWith(VALID_RESPONSE_PREFIX);
    }

    public boolean isErrorResponse() {
        String payload = this.getPayload();
        return payload != null && payload.startsWith(ERROR_RESPONSE_PREFIX);
    }

    public String getErrorMessage() {
        String payload = this.getPayload();
        if (payload != null) {
            return payload.replace(ERROR_RESPONSE_PREFIX, "");
        }
        return null;
    }
}

