/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.shoutcast.v2;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastFormat;
import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;

public class ShoutcastV2Configuration
extends BroadcastConfiguration {
    private IntegerProperty mStreamID = new SimpleIntegerProperty();
    private String mUserID;
    private int mBitRate = 16;
    private String mGenre;
    private String mURL;
    private boolean mPublic = true;

    public ShoutcastV2Configuration() {
        this(BroadcastFormat.MP3);
    }

    public ShoutcastV2Configuration(BroadcastFormat format) {
        super(format);
        this.mValid.bind((ObservableValue)Bindings.and((ObservableBooleanValue)Bindings.and((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.mHost), (ObservableBooleanValue)Bindings.greaterThan((ObservableNumberValue)this.mPort, (int)0)), (ObservableBooleanValue)Bindings.greaterThan((ObservableNumberValue)this.mStreamID, (int)-1)));
    }

    @Override
    public BroadcastConfiguration copyOf() {
        ShoutcastV2Configuration copy = new ShoutcastV2Configuration(this.getBroadcastFormat());
        copy.setName(this.getName());
        copy.setHost(this.getHost());
        copy.setPort(this.getPort());
        copy.setPassword(this.getPassword());
        copy.setDelay(this.getDelay());
        copy.setEnabled(false);
        copy.setStreamID(this.getStreamID());
        copy.setUserID(this.getUserID());
        copy.setBitRate(this.getBitRate());
        copy.setGenre(this.getGenre());
        copy.setURL(this.getURL());
        copy.setPublic(this.isPublic());
        return copy;
    }

    @Override
    public BroadcastServerType getBroadcastServerType() {
        return BroadcastServerType.SHOUTCAST_V2;
    }

    @JacksonXmlProperty(isAttribute=true, localName="stream_id")
    public int getStreamID() {
        return this.mStreamID.get();
    }

    public void setStreamID(int streamID) {
        this.mStreamID.set(streamID);
    }

    @JacksonXmlProperty(isAttribute=true, localName="user_id")
    public String getUserID() {
        return this.mUserID;
    }

    public void setUserID(String userID) {
        this.mUserID = userID;
    }

    @JacksonXmlProperty(isAttribute=true, localName="bitrate")
    public int getBitRate() {
        return this.mBitRate;
    }

    public void setBitRate(int bitRate) {
        this.mBitRate = bitRate;
    }

    @JacksonXmlProperty(isAttribute=true, localName="genre")
    public String getGenre() {
        return this.mGenre;
    }

    public void setGenre(String genre) {
        this.mGenre = genre;
    }

    public boolean hasGenre() {
        return this.mGenre != null && !this.mGenre.isEmpty();
    }

    @JacksonXmlProperty(isAttribute=true, localName="public")
    public boolean isPublic() {
        return this.mPublic;
    }

    public void setPublic(boolean isPublic) {
        this.mPublic = isPublic;
    }

    @JacksonXmlProperty(isAttribute=true, localName="url")
    public String getURL() {
        return this.mURL;
    }

    public void setURL(String url) {
        this.mURL = url;
    }

    public boolean hasURL() {
        return this.mURL != null && !this.mURL.isEmpty();
    }
}

