/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.rdioscanner;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastFormat;
import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;

public class RdioScannerConfiguration
extends BroadcastConfiguration {
    private IntegerProperty mSystemID = new SimpleIntegerProperty();
    private StringProperty mApiKey = new SimpleStringProperty();

    public RdioScannerConfiguration() {
        this(BroadcastFormat.MP3);
    }

    public RdioScannerConfiguration(BroadcastFormat format) {
        super(format);
        this.mValid.unbind();
        this.mValid.bind((ObservableValue)Bindings.and((ObservableBooleanValue)Bindings.and((ObservableBooleanValue)Bindings.greaterThan((ObservableNumberValue)this.mSystemID, (int)0), (ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.mApiKey)), (ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.mHost)));
        if (this.mHost.getValue() == null || this.mHost.getValue().isEmpty()) {
            this.mHost.set((Object)"http://localhost");
        }
    }

    public IntegerProperty systemIDProperty() {
        return this.mSystemID;
    }

    public StringProperty apiKeyProperty() {
        return this.mApiKey;
    }

    @JacksonXmlProperty(isAttribute=true, localName="api_key")
    public String getApiKey() {
        return (String)this.mApiKey.get();
    }

    public void setApiKey(String apiKey) {
        this.mApiKey.setValue(apiKey);
    }

    @JacksonXmlProperty(isAttribute=true, localName="system_id")
    public int getSystemID() {
        return this.mSystemID.get();
    }

    public void setSystemID(int systemID) {
        this.mSystemID.set(systemID);
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public BroadcastServerType getBroadcastServerType() {
        return BroadcastServerType.RDIOSCANNER_CALL;
    }

    @Override
    public BroadcastConfiguration copyOf() {
        RdioScannerConfiguration copy = new RdioScannerConfiguration();
        copy.setSystemID(this.getSystemID());
        return copy;
    }
}

