/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.openmhz;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastFormat;
import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;

public class OpenMHzConfiguration
extends BroadcastConfiguration {
    public static final String PRODUCTION_ENDPOINT = "https://api.openmhz.com";
    private StringProperty mSystemName = new SimpleStringProperty();
    private StringProperty mApiKey = new SimpleStringProperty();

    public OpenMHzConfiguration() {
        this(BroadcastFormat.MP3);
    }

    public OpenMHzConfiguration(BroadcastFormat format) {
        super(format);
        if (this.getHost() == null) {
            this.setHost(PRODUCTION_ENDPOINT);
        }
        this.mValid.unbind();
        this.mValid.bind((ObservableValue)Bindings.and((ObservableBooleanValue)Bindings.and((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.mSystemName), (ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.mApiKey)), (ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.mHost)));
    }

    public StringProperty systemIDProperty() {
        return this.mSystemName;
    }

    public StringProperty apiKeyProperty() {
        return this.mApiKey;
    }

    @JacksonXmlProperty(isAttribute=true, localName="api_key")
    public String getApiKey() {
        return (String)this.mApiKey.get();
    }

    public void setApiKey(String apiKey) {
        this.mApiKey.setValue(apiKey);
    }

    @JacksonXmlProperty(isAttribute=true, localName="system_name")
    public String getSystemName() {
        return (String)this.mSystemName.get();
    }

    public void setSystemName(String systemName) {
        this.mSystemName.set((Object)systemName);
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public BroadcastServerType getBroadcastServerType() {
        return BroadcastServerType.OPENMHZ;
    }

    @Override
    public BroadcastConfiguration copyOf() {
        OpenMHzConfiguration copy = new OpenMHzConfiguration();
        copy.setSystemName(this.getSystemName());
        return copy;
    }
}

