/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.openmhz;

import io.github.dsheirer.audio.broadcast.openmhz.FormField;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;

public class OpenMHzBuilder {
    private static final String DASH_DASH = "--";
    private static final String BOUNDARY = "--sdrtrunk-sdrtrunk-sdrtrunk";
    private List<Part> mParts = new ArrayList<Part>();
    private byte[] audioBytes = null;

    public String getBoundary() {
        return BOUNDARY;
    }

    public OpenMHzBuilder addFile(byte[] value) {
        this.audioBytes = value;
        return this;
    }

    public OpenMHzBuilder addPart(FormField key, String value) {
        if (key != null && value != null) {
            this.mParts.add(new Part(this, key.getHeader(), value));
        }
        return this;
    }

    public OpenMHzBuilder addPart(FormField key, Number value) {
        if (key != null && value != null) {
            this.mParts.add(new Part(this, key.getHeader(), value.toString()));
        }
        return this;
    }

    private static String formatPart(Part part, String boundary) {
        StringBuilder sb = new StringBuilder();
        sb.append(DASH_DASH).append(boundary).append("\r\n");
        sb.append("Content-Disposition: form-data; name=\"").append(part.mKey).append("\"\r\n\r\n");
        sb.append(part.getValue()).append("\r\n");
        return sb.toString();
    }

    private String formatFilePart(String boundary) {
        if (this.audioBytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(DASH_DASH).append(boundary).append("\r\n");
        sb.append("Content-Disposition: form-data; name=\"").append("call").append("\"; filename=\"audio.mp3\"\r\n\r\n");
        return sb.toString();
    }

    private static String getClosingBoundary(String boundary) {
        StringBuilder sb = new StringBuilder();
        sb.append(DASH_DASH).append(boundary).append(DASH_DASH).append("\r\n");
        return sb.toString();
    }

    public HttpRequest.BodyPublisher build() {
        StringBuilder sb = new StringBuilder();
        for (Part part : this.mParts) {
            sb.append(OpenMHzBuilder.formatPart(part, BOUNDARY));
        }
        sb.append(this.formatFilePart(BOUNDARY));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(sb.toString().getBytes());
            if (this.audioBytes != null) {
                outputStream.write(this.audioBytes);
            }
            sb = new StringBuilder();
            sb.append("\r\n");
            sb.append(OpenMHzBuilder.getClosingBoundary(BOUNDARY));
            outputStream.write(sb.toString().getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return HttpRequest.BodyPublishers.ofByteArray(outputStream.toByteArray());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Part part : this.mParts) {
            sb.append(OpenMHzBuilder.formatPart(part, BOUNDARY));
        }
        sb.append(OpenMHzBuilder.getClosingBoundary(BOUNDARY));
        return sb.toString();
    }

    public class Part {
        private String mKey;
        private String mValue;

        public Part(OpenMHzBuilder this$0, String key, String value) {
            this.mKey = key;
            this.mValue = value;
        }

        public String getKey() {
            return this.mKey;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

