/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.icecast.codec;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.filter.codec.textline.TextLineEncoder;

public class IcecastEncoder
extends ProtocolEncoderAdapter {
    private static final AttributeKey ENCODER = new AttributeKey(TextLineEncoder.class, "encoder");
    private static final Charset mCharset = StandardCharsets.UTF_8;
    private static final int MAX_LINE_LENGTH = Integer.MAX_VALUE;

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        if (message instanceof byte[]) {
            byte[] data = (byte[])message;
            IoBuffer buf = IoBuffer.allocate((int)data.length).setAutoExpand(false);
            buf.put(data);
            buf.flip();
            out.write((Object)buf);
        } else if (message instanceof String) {
            CharsetEncoder encoder = (CharsetEncoder)session.getAttribute((Object)ENCODER);
            if (encoder == null) {
                encoder = mCharset.newEncoder();
                session.setAttribute((Object)ENCODER, (Object)encoder);
            }
            String value = (String)message;
            IoBuffer buf = IoBuffer.allocate((int)value.length()).setAutoExpand(true);
            buf.putString((CharSequence)value, encoder);
            if (buf.position() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Line length: " + buf.position());
            }
            buf.putString((CharSequence)LineDelimiter.UNIX.getValue(), encoder);
            buf.flip();
            out.write((Object)buf);
        } else {
            throw new IllegalArgumentException("Can't encode - unrecognized object type: " + String.valueOf(message.getClass()));
        }
    }
}

