/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.icecast;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastFormat;
import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import io.github.dsheirer.audio.broadcast.broadcastify.BroadcastifyFeedConfiguration;
import io.github.dsheirer.audio.broadcast.icecast.IcecastConfiguration;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=BroadcastifyFeedConfiguration.class, name="broadcastifyConfiguration")})
public class IcecastTCPConfiguration
extends IcecastConfiguration {
    private static final Logger mLog = LoggerFactory.getLogger(IcecastTCPConfiguration.class);

    public IcecastTCPConfiguration() {
        this(BroadcastFormat.MP3);
    }

    public IcecastTCPConfiguration(BroadcastFormat format) {
        super(format);
        this.mValid.bind((ObservableValue)Bindings.and((ObservableBooleanValue)Bindings.and((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.mHost), (ObservableBooleanValue)Bindings.greaterThan((ObservableNumberValue)this.mPort, (int)0)), (ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.mMountPoint)));
    }

    @Override
    public BroadcastConfiguration copyOf() {
        IcecastTCPConfiguration copy = new IcecastTCPConfiguration(this.getBroadcastFormat());
        copy.setName(this.getName());
        copy.setHost(this.getHost());
        copy.setPort(this.getPort());
        copy.setInline(this.getInline());
        copy.setPassword(this.getPassword());
        copy.setDelay(this.getDelay());
        copy.setEnabled(false);
        copy.setUserName(this.getUserName());
        copy.setMountPoint(this.getMountPoint());
        copy.setDescription(this.getDescription());
        copy.setGenre(this.getGenre());
        copy.setPublic(this.isPublic());
        copy.setURL(this.getURL());
        return copy;
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public BroadcastServerType getBroadcastServerType() {
        return BroadcastServerType.ICECAST_TCP;
    }
}

