/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.icecast;

import com.google.common.base.Joiner;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.Role;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcecastMetadata {
    private static final Logger mLog = LoggerFactory.getLogger(IcecastMetadata.class);

    public static String getTitle(IdentifierCollection identifierCollection, AliasModel AliasModel2) {
        StringBuilder sb = new StringBuilder();
        if (identifierCollection != null) {
            List<Identifier> fromIdentifiers;
            List<Identifier> toIdentifiers;
            AliasList aliasList = AliasModel2.getAliasList(identifierCollection);
            Identifier to = identifierCollection.getIdentifier(IdentifierClass.USER, Form.PATCH_GROUP, Role.TO);
            if (to == null) {
                to = identifierCollection.getIdentifier(IdentifierClass.USER, Form.TALKGROUP, Role.TO);
            }
            if (to == null && !(toIdentifiers = identifierCollection.getIdentifiers(Role.TO)).isEmpty()) {
                to = toIdentifiers.get(0);
            }
            if (to != null) {
                sb.append("TO:").append(to);
                List<Alias> aliases = aliasList.getAliases(to);
                if (aliases != null && !aliases.isEmpty()) {
                    sb.append(" ").append(Joiner.on((String)", ").skipNulls().join(aliases));
                }
            } else {
                sb.append("TO:UNKNOWN");
            }
            Identifier from = identifierCollection.getIdentifier(IdentifierClass.USER, Form.RADIO, Role.FROM);
            if (from == null && !(fromIdentifiers = identifierCollection.getIdentifiers(Role.FROM)).isEmpty()) {
                from = fromIdentifiers.get(0);
            }
            if (from != null) {
                sb.append(" FROM:").append(from);
                List<Alias> aliases = aliasList.getAliases(from);
                if (aliases != null && !aliases.isEmpty()) {
                    sb.append(" ").append(Joiner.on((String)", ").skipNulls().join(aliases));
                }
            } else {
                sb.append(" FROM:UNKNOWN");
            }
        } else {
            sb.append("Scanning...");
        }
        return sb.toString();
    }

    public static String formatInline(String title) {
        title = "StreamTitle='" + (String)title + "';";
        int chunks = (int)Math.ceil((double)(((String)title).length() + 1) / 16.0);
        int nulls = chunks * 16 - ((String)title).length();
        char[] padding = new char[nulls];
        StringBuilder sb = new StringBuilder();
        sb.append((char)chunks).append((String)title).append(padding);
        return sb.toString();
    }
}

