/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.audio.broadcast.icecast;

import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.broadcast.IBroadcastMetadataUpdater;
import io.github.dsheirer.audio.broadcast.icecast.IcecastConfiguration;
import io.github.dsheirer.audio.broadcast.icecast.IcecastHeader;
import io.github.dsheirer.audio.broadcast.icecast.IcecastMetadata;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.util.ThreadPool;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcecastBroadcastMetadataUpdater
implements IBroadcastMetadataUpdater {
    private static final Logger mLog = LoggerFactory.getLogger(IcecastBroadcastMetadataUpdater.class);
    private static final String UTF8 = "UTF-8";
    private HttpClient mHttpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).build();
    private IcecastConfiguration mIcecastConfiguration;
    private AliasModel mAliasModel;
    private boolean mConnectionLoggingSuppressed = false;

    public IcecastBroadcastMetadataUpdater(IcecastConfiguration icecastConfiguration, AliasModel aliasModel) {
        this.mIcecastConfiguration = icecastConfiguration;
        this.mAliasModel = aliasModel;
    }

    @Override
    public void update(IdentifierCollection identifierCollection) {
        if (this.mIcecastConfiguration.hasInline()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("http://");
            sb.append(this.mIcecastConfiguration.getHost());
            sb.append(":");
            sb.append(this.mIcecastConfiguration.getPort());
            sb.append("/admin/metadata?mode=updinfo&mount=");
            sb.append(URLEncoder.encode(this.mIcecastConfiguration.getMountPoint(), UTF8));
            sb.append("&charset=UTF%2d8");
            sb.append("&song=").append(URLEncoder.encode(IcecastMetadata.getTitle(identifierCollection, this.mAliasModel), UTF8));
        }
        catch (UnsupportedEncodingException uee) {
            mLog.error("Error encoding metadata information to UTF-8", (Throwable)uee);
            sb = null;
        }
        if (sb != null) {
            final String metadataUpdateURL = sb.toString();
            final URI uri = URI.create(metadataUpdateURL);
            ThreadPool.CACHED.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        HttpRequest request = HttpRequest.newBuilder().uri(uri).header(IcecastHeader.AUTHORIZATION.getValue(), IcecastBroadcastMetadataUpdater.this.mIcecastConfiguration.getBase64EncodedCredentials()).header(IcecastHeader.USER_AGENT.getValue(), SystemProperties.getInstance().getApplicationName()).GET().build();
                        HttpResponse<String> response = null;
                        try {
                            response = IcecastBroadcastMetadataUpdater.this.mHttpClient.send(request, HttpResponse.BodyHandlers.ofString());
                        }
                        catch (IOException ioe) {
                            if (!IcecastBroadcastMetadataUpdater.this.mConnectionLoggingSuppressed) {
                                mLog.error("IO Error submitting Icecast metadata update [" + (metadataUpdateURL != null ? metadataUpdateURL : "no url"), (Throwable)ioe);
                                IcecastBroadcastMetadataUpdater.this.mConnectionLoggingSuppressed = true;
                            }
                        }
                        catch (InterruptedException ie) {
                            mLog.error("Interrupted Exception Error", (Throwable)ie);
                        }
                        if (response != null) {
                            if (response.statusCode() == 200) {
                                IcecastBroadcastMetadataUpdater.this.mConnectionLoggingSuppressed = false;
                            } else if (!IcecastBroadcastMetadataUpdater.this.mConnectionLoggingSuppressed) {
                                mLog.info("Error submitting Icecast 2 Metadata update to URL [" + metadataUpdateURL + "] HTTP Response Code [" + response.statusCode() + "] Body [" + response.body() + "]");
                                IcecastBroadcastMetadataUpdater.this.mConnectionLoggingSuppressed = true;
                            }
                        }
                    }
                    catch (Throwable t) {
                        mLog.error("There was an error submitting an Icecast metadata update", t);
                    }
                }
            });
        }
    }
}

